/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.noear.dami2.Dami;
import org.noear.dami2.bus.DamiBus;
import org.noear.solon.flow.FlowExchanger;
import org.noear.solon.flow.stateful.StateController;
import org.noear.solon.flow.stateful.StateRepository;
import org.noear.solon.flow.stateful.StatefulFlowContext;
import org.noear.solon.flow.stateful.StatefulSupporter;
import org.noear.solon.flow.stateful.repository.InMemoryStateRepository;
import org.noear.solon.flow.stateless.StatelessFlowContext;
import org.noear.solon.lang.Nullable;
import org.noear.solon.lang.Preview;

@Preview(value="3.0")
public interface FlowContext {
    public static FlowContext of() {
        return new StatelessFlowContext();
    }

    public static FlowContext of(String instanceId) {
        return new StatelessFlowContext(instanceId);
    }

    public static FlowContext of(String instanceId, StateController stateController, StateRepository stateRepository) {
        return new StatefulFlowContext(instanceId, stateController, stateRepository);
    }

    public static FlowContext of(String instanceId, StateController stateController) {
        return new StatefulFlowContext(instanceId, stateController, new InMemoryStateRepository());
    }

    @Preview(value="3.3")
    @Nullable
    public ExecutorService executor();

    @Preview(value="3.3")
    public FlowContext executor(ExecutorService var1);

    @Preview(value="3.5")
    @Nullable
    default public FlowExchanger exchanger() {
        return (FlowExchanger)this.getAs("exchanger");
    }

    public Map<String, Object> model();

    default public String getInstanceId() {
        return (String)this.getAs("instanceId");
    }

    @Preview(value="3.5")
    public boolean isStateful();

    @Preview(value="3.5")
    public StatefulSupporter statefulSupporter();

    default public DamiBus eventBus() {
        return this.computeIfAbsent("eventBus", k -> Dami.newBus());
    }

    default public FlowContext put(String key, Object value) {
        if (value != null) {
            this.model().put(key, value);
        }
        return this;
    }

    default public FlowContext putIfAbsent(String key, Object value) {
        if (value != null) {
            this.model().putIfAbsent(key, value);
        }
        return this;
    }

    default public FlowContext putAll(Map<String, Object> model) {
        this.model().putAll(model);
        return this;
    }

    default public <T> T computeIfAbsent(String key, Function<String, T> mappingFunction) {
        return (T)this.model().computeIfAbsent(key, mappingFunction);
    }

    default public Object get(String key) {
        return this.model().get(key);
    }

    default public <T> T getAs(String key) {
        return (T)this.model().get(key);
    }

    default public <T> T getOrDefault(String key, T def) {
        return (T)this.model().getOrDefault(key, def);
    }

    default public int incrAdd(String key, int delta) {
        AtomicInteger tmp = (AtomicInteger)this.model().computeIfAbsent(key, (? super K k) -> new AtomicInteger(0));
        return tmp.addAndGet(delta);
    }

    default public int incrGet(String key) {
        AtomicInteger tmp = (AtomicInteger)this.model().computeIfAbsent(key, (? super K k) -> new AtomicInteger(0));
        return tmp.get();
    }

    default public void remove(String key) {
        this.model().remove(key);
    }
}

