/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.noear.solon.Utils;
import org.noear.solon.flow.LinkDecl;
import org.noear.solon.flow.NodeType;

public class NodeDecl {
    protected final String id;
    protected String title;
    protected NodeType type;
    protected final Map<String, Object> meta = new LinkedHashMap<String, Object>();
    protected List<LinkDecl> links = new ArrayList<LinkDecl>();
    protected String when;
    protected String task;

    public NodeDecl(String id, NodeType type) {
        this.id = id;
        this.type = type;
    }

    public NodeDecl title(String title) {
        this.title = title;
        return this;
    }

    public NodeDecl meta(Map<String, Object> map) {
        if (Utils.isNotEmpty(map)) {
            this.meta.putAll(map);
        }
        return this;
    }

    public NodeDecl metaPut(String key, Object value) {
        if (Utils.isNotEmpty((String)key)) {
            this.meta.put(key, value);
        }
        return this;
    }

    public NodeDecl linkAdd(String nextId, Consumer<LinkDecl> configure) {
        LinkDecl linkDecl = new LinkDecl(nextId);
        if (configure != null) {
            configure.accept(linkDecl);
        }
        this.links.add(linkDecl);
        return this;
    }

    public NodeDecl linkAdd(String nextId) {
        return this.linkAdd(nextId, null);
    }

    public NodeDecl when(String when) {
        this.when = when;
        return this;
    }

    public NodeDecl task(String task) {
        this.task = task;
        return this;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{");
        buf.append("id='").append(this.id).append('\'');
        if (Utils.isNotEmpty((String)this.title)) {
            buf.append(", title='").append(this.title).append('\'');
        }
        if (this.type != null) {
            buf.append(", type=").append((Object)this.type);
        }
        if (Utils.isNotEmpty(this.meta)) {
            buf.append(", meta=").append(this.meta);
        }
        if (Utils.isNotEmpty(this.links)) {
            buf.append(", links=").append(this.links);
        }
        if (Utils.isNotEmpty((String)this.when)) {
            buf.append(", when='").append(this.when).append('\'');
        }
        if (Utils.isNotEmpty((String)this.task)) {
            buf.append(", task='").append(this.task).append('\'');
        }
        buf.append('}');
        return buf.toString();
    }

    public static NodeDecl startOf(String id) {
        return new NodeDecl(id, NodeType.START);
    }

    public static NodeDecl endOf(String id) {
        return new NodeDecl(id, NodeType.END);
    }

    public static NodeDecl activityOf(String id) {
        return new NodeDecl(id, NodeType.ACTIVITY);
    }

    public static NodeDecl inclusiveOf(String id) {
        return new NodeDecl(id, NodeType.INCLUSIVE);
    }

    public static NodeDecl exclusiveOf(String id) {
        return new NodeDecl(id, NodeType.EXCLUSIVE);
    }

    public static NodeDecl parallelOf(String id) {
        return new NodeDecl(id, NodeType.PARALLEL);
    }

    public static NodeDecl iteratorOf(String id) {
        return new NodeDecl(id, NodeType.ITERATOR);
    }
}

