/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.flow.Chain;
import org.noear.solon.flow.Condition;
import org.noear.solon.flow.LinkDecl;
import org.noear.solon.flow.Node;

public class Link
implements Comparable<Link> {
    private final Chain chain;
    private final String prevId;
    private final LinkDecl decl;
    private Node prevNode;
    private Node nextNode;
    private Condition when;

    public Link(Chain chain, String prevId, LinkDecl decl) {
        this.chain = chain;
        this.prevId = prevId;
        this.decl = decl;
    }

    public Chain getChain() {
        return this.chain;
    }

    public String getTitle() {
        return this.decl.title;
    }

    public Map<String, Object> getMetas() {
        return this.decl.meta;
    }

    public Object getMeta(String key) {
        return this.decl.meta.get(key);
    }

    public Object getMetaOrDefault(String key, Object def) {
        return this.decl.meta.getOrDefault(key, def);
    }

    public Condition getWhen() {
        if (this.when == null) {
            this.when = new Condition(this.chain, this.decl.when);
        }
        return this.when;
    }

    @Deprecated
    public Condition getCondition() {
        return this.getWhen();
    }

    public String getPrevId() {
        return this.prevId;
    }

    public String getNextId() {
        return this.decl.nextId;
    }

    public Node getPrevNode() {
        if (this.prevNode == null) {
            this.prevNode = this.chain.getNode(this.getPrevId());
        }
        return this.prevNode;
    }

    public Node getNextNode() {
        if (this.nextNode == null) {
            this.nextNode = this.chain.getNode(this.getNextId());
        }
        return this.nextNode;
    }

    @Override
    public int compareTo(Link o) {
        if (this.decl.priority > o.decl.priority) {
            return -1;
        }
        if (this.decl.priority < o.decl.priority) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        buf.append("priority=").append(this.decl.priority);
        buf.append(", prevId='").append(this.getPrevId()).append('\'');
        buf.append(", nextId='").append(this.getNextId()).append('\'');
        if (Utils.isNotEmpty((String)this.decl.title)) {
            buf.append(", title='").append(this.decl.title).append('\'');
        }
        if (Utils.isNotEmpty(this.decl.meta)) {
            buf.append(", meta=").append(this.decl.meta);
        }
        if (Utils.isNotEmpty((String)this.decl.when)) {
            buf.append(", when=").append(this.decl.when);
        }
        buf.append("}");
        return buf.toString();
    }
}

