/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.flow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.flow.Chain;
import org.noear.solon.flow.Condition;
import org.noear.solon.flow.Link;
import org.noear.solon.flow.NodeDecl;
import org.noear.solon.flow.NodeType;
import org.noear.solon.flow.Task;
import org.noear.solon.lang.Preview;

public class Node {
    public static final String TAG = "node";
    private final transient Chain chain;
    private final NodeDecl decl;
    private final List<Link> nextLinks = new ArrayList<Link>();
    private List<Node> prevNodes;
    private List<Node> nextNodes;
    private List<Link> prevLinks;
    private Condition when;
    private Task task;
    private NodeType imode = NodeType.UNKNOWN;
    private NodeType omode = NodeType.UNKNOWN;
    public Object attachment;

    protected Node(Chain chain, NodeDecl decl, List<Link> links) {
        this.chain = chain;
        this.decl = decl;
        if (links != null) {
            this.nextLinks.addAll(links);
            Collections.sort(this.nextLinks);
        }
        this.ioModeInit();
    }

    private void ioModeInit() {
        String i_mode = this.getMetaAsString("$imode");
        this.imode = NodeType.nameOf(i_mode, NodeType.UNKNOWN);
        String o_mode = this.getMetaAsString("$omode");
        this.omode = NodeType.nameOf(o_mode, NodeType.UNKNOWN);
    }

    @Preview(value="3.4")
    protected NodeType getImode() {
        return this.imode;
    }

    @Preview(value="3.4")
    protected NodeType getOmode() {
        return this.omode;
    }

    public Chain getChain() {
        return this.chain;
    }

    public String getId() {
        return this.decl.id;
    }

    public String getTitle() {
        return this.decl.title;
    }

    public NodeType getType() {
        return this.decl.type;
    }

    public Map<String, Object> getMetas() {
        return Collections.unmodifiableMap(this.decl.meta);
    }

    public <T> T getMeta(String key) {
        return (T)this.decl.meta.get(key);
    }

    public boolean hasMeta(String key) {
        return this.decl.meta.containsKey(key);
    }

    public String getMetaAsString(String key) {
        Object tmp = this.decl.meta.get(key);
        if (tmp == null) {
            return null;
        }
        if (tmp instanceof String) {
            return (String)tmp;
        }
        return tmp.toString();
    }

    public Boolean getMetaAsBool(String key) {
        Object tmp = this.decl.meta.get(key);
        if (tmp == null) {
            return null;
        }
        if (tmp instanceof Boolean) {
            return (Boolean)tmp;
        }
        if (tmp instanceof String) {
            return Boolean.parseBoolean((String)tmp);
        }
        if (tmp instanceof Number) {
            return ((Number)tmp).doubleValue() > 0.0;
        }
        throw new UnsupportedOperationException(key);
    }

    public Number getMetaAsNumber(String key) {
        Object tmp = this.decl.meta.get(key);
        if (tmp == null) {
            return null;
        }
        if (tmp instanceof String) {
            return Double.parseDouble((String)tmp);
        }
        if (tmp instanceof Number) {
            return (Number)tmp;
        }
        throw new UnsupportedOperationException(key);
    }

    public <T> T getMetaOrDefault(String key, T def) {
        return (T)this.decl.meta.getOrDefault(key, def);
    }

    public List<Link> getPrevLinks() {
        if (this.prevLinks == null) {
            ArrayList<Link> tmp = new ArrayList<Link>();
            if (this.getType() != NodeType.START) {
                for (Link l : this.chain.getLinks()) {
                    if (!this.getId().equals(l.getNextId())) continue;
                    tmp.add(l);
                }
                Collections.reverse(tmp);
            }
            this.prevLinks = Collections.unmodifiableList(tmp);
        }
        return this.prevLinks;
    }

    public List<Link> getNextLinks() {
        return Collections.unmodifiableList(this.nextLinks);
    }

    public List<Node> getPrevNodes() {
        if (this.prevNodes == null) {
            ArrayList<Node> tmp = new ArrayList<Node>();
            if (this.getType() != NodeType.START) {
                for (Link l : this.chain.getLinks()) {
                    if (!this.getId().equals(l.getNextId())) continue;
                    tmp.add(this.chain.getNode(l.getPrevId()));
                }
            }
            this.prevNodes = Collections.unmodifiableList(tmp);
        }
        return this.prevNodes;
    }

    public List<Node> getNextNodes() {
        if (this.nextNodes == null) {
            ArrayList<Node> tmp = new ArrayList<Node>();
            if (this.getType() != NodeType.END) {
                for (Link l : this.getNextLinks()) {
                    tmp.add(this.chain.getNode(l.getNextId()));
                }
            }
            this.nextNodes = Collections.unmodifiableList(tmp);
        }
        return this.nextNodes;
    }

    public Node getNextNode() {
        if (this.getNextNodes().size() > 0) {
            return this.getNextNodes().get(0);
        }
        return null;
    }

    public Condition getWhen() {
        if (this.when == null) {
            this.when = new Condition(this.chain, this.decl.when);
        }
        return this.when;
    }

    public Task getTask() {
        if (this.task == null) {
            this.task = new Task(this, this.decl.task);
        }
        return this.task;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        buf.append("id='").append(this.decl.id).append('\'');
        buf.append(", type='").append((Object)this.decl.type).append('\'');
        if (Utils.isNotEmpty((String)this.decl.title)) {
            buf.append(", title='").append(this.decl.title).append('\'');
        }
        if (Utils.isNotEmpty((String)this.decl.when)) {
            buf.append(", when='").append(this.decl.when).append('\'');
        }
        if (Utils.isNotEmpty((String)this.decl.task)) {
            buf.append(", task='").append(this.decl.task).append('\'');
        }
        if (Utils.isNotEmpty(this.decl.links)) {
            buf.append(", link=").append(this.decl.links);
        }
        if (Utils.isNotEmpty(this.decl.meta)) {
            buf.append(", meta=").append(this.decl.meta);
        }
        buf.append("}");
        return buf.toString();
    }
}

