/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.health.detector;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.solon.health.detector.Detector;

public class DetectorManager {
    private static final Map<String, Detector> detectorMap = new LinkedHashMap<String, Detector>();

    public static void add(Detector detector) {
        detectorMap.put(detector.getName(), detector);
    }

    public static void remove(String name) {
        detectorMap.remove(name);
    }

    public static Detector get(String name) {
        return detectorMap.get(name);
    }

    public static Collection<Detector> all() {
        return detectorMap.values();
    }

    public static Map<String, Detector> getMore(String ... names) {
        HashMap<String, Detector> tmp = new HashMap<String, Detector>();
        for (String name : names) {
            if ("*".equals(name)) {
                for (Detector detector : detectorMap.values()) {
                    tmp.put(detector.getName(), detector);
                }
                break;
            }
            Detector detector = DetectorManager.get(name);
            if (detector == null) continue;
            tmp.put(detector.getName(), detector);
        }
        return tmp;
    }

    public static void start(String ... names) throws Throwable {
        for (String name : names) {
            if ("*".equals(name)) {
                for (Detector detector : detectorMap.values()) {
                    detector.start();
                }
                break;
            }
            Detector detector = DetectorManager.get(name);
            if (detector == null) continue;
            detector.start();
        }
    }
}

