/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.i18n.impl;

import java.util.Locale;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.i18n.LocaleResolver;
import org.noear.solon.i18n.LocaleUtil;

public class LocaleResolverHeader
implements LocaleResolver {
    private String headerName1;
    private static final String headerName2 = "Content-Language";
    private static final String headerName3 = "Accept-Language";

    public void setHeaderName(String headerName) {
        this.headerName1 = headerName;
    }

    @Override
    public Locale getLocale(Context ctx) {
        if (ctx.getLocale() == null) {
            String lang = null;
            if (Utils.isNotEmpty((String)this.headerName1)) {
                lang = ctx.header(this.headerName1);
            }
            if (Utils.isEmpty(lang)) {
                lang = ctx.header(headerName2);
            }
            if (Utils.isEmpty((String)lang)) {
                lang = ctx.header(headerName3);
            }
            if (Utils.isEmpty((String)lang)) {
                ctx.setLocale(Solon.cfg().locale());
            } else {
                if (lang.contains(",")) {
                    lang = lang.split(",")[0];
                }
                ctx.setLocale(LocaleUtil.toLocale(lang));
            }
        }
        return ctx.getLocale();
    }

    @Override
    public void setLocale(Context ctx, Locale locale) {
        if (!Utils.isEmpty((String)this.headerName1)) {
            ctx.headerSet(this.headerName1, locale.getLanguage());
            ctx.setLocale(locale);
        }
    }
}

