/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

public class ClassesMove {
    public static void change(File file) {
        String target = file.getParent() + File.separator;
        String name = file.getName();
        String desc = name.substring(0, name.lastIndexOf("."));
        File file1 = new File(target + desc);
        if (file1.isDirectory()) {
            ClassesMove.deleteDirectory(file1.getAbsolutePath());
        }
        file1.mkdirs();
        try {
            ClassesMove.unzipJar(file1.getPath(), file.getAbsolutePath());
            ClassesMove.deleteFile(file.getAbsolutePath());
            ClassesMove.jar(file.getAbsolutePath(), file1);
            ClassesMove.deleteDirectory(file1.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void jar(String jarFileName, File f) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(jarFileName);
        JarOutputStream out = new JarOutputStream(fileOutputStream);
        ClassesMove.jar(out, f, "BOOT-INF/classes");
        out.flush();
        out.close();
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    private static void jar(JarOutputStream out, File f, String base) throws Exception {
        if (f.isDirectory()) {
            File[] fl = f.listFiles();
            out.putNextEntry(new JarEntry(base + "/"));
            base = base.length() == 0 ? "" : base + "/";
            for (int i = 0; i < fl.length; ++i) {
                ClassesMove.jar(out, fl[i], base + fl[i].getName());
            }
        } else {
            int b;
            out.putNextEntry(new ZipEntry(base));
            FileInputStream in = new FileInputStream(f);
            while ((b = in.read()) != -1) {
                out.write(b);
            }
            in.close();
        }
    }

    public static boolean deleteDirectory(String dir) {
        File dirFile;
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        if (!(dirFile = new File(dir)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length && !(files[i].isFile() ? !(flag = ClassesMove.deleteFile(files[i].getAbsolutePath())) : files[i].isDirectory() && !(flag = ClassesMove.deleteDirectory(files[i].getAbsolutePath()))); ++i) {
        }
        if (!flag) {
            return false;
        }
        return dirFile.delete();
    }

    public static boolean deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            return file.delete();
        }
        return false;
    }

    public static void unzipJar(String destinationDir, String jarPath) throws IOException {
        File f;
        String fileName;
        JarEntry entry;
        File file = new File(jarPath);
        JarFile jar = new JarFile(file);
        Enumeration<JarEntry> enums = jar.entries();
        while (enums.hasMoreElements()) {
            entry = enums.nextElement();
            fileName = destinationDir + File.separator + entry.getName();
            f = new File(fileName);
            if (!fileName.endsWith("/")) continue;
            f.mkdirs();
        }
        enums = jar.entries();
        while (enums.hasMoreElements()) {
            entry = enums.nextElement();
            fileName = destinationDir + File.separator + entry.getName();
            f = new File(fileName);
            if (fileName.endsWith("/")) continue;
            InputStream is = jar.getInputStream(entry);
            FileOutputStream fos = new FileOutputStream(f);
            while (is.available() > 0) {
                fos.write(is.read());
            }
            fos.close();
            is.close();
        }
        jar.close();
    }
}

