/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.maven.plugin;

import java.util.Arrays;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

class JavaCompilerPluginConfiguration {
    private final MavenProject project;

    JavaCompilerPluginConfiguration(MavenProject project) {
        this.project = project;
    }

    String getSourceMajorVersion() {
        String version = this.getConfigurationValue("source");
        if (version == null) {
            version = this.getPropertyValue("maven.compiler.source");
        }
        return this.majorVersionFor(version);
    }

    String getTargetMajorVersion() {
        String version = this.getConfigurationValue("target");
        if (version == null) {
            version = this.getPropertyValue("maven.compiler.target");
        }
        return this.majorVersionFor(version);
    }

    String getReleaseVersion() {
        String version = this.getConfigurationValue("release");
        if (version == null) {
            version = this.getPropertyValue("maven.compiler.release");
        }
        return this.majorVersionFor(version);
    }

    private String getConfigurationValue(String propertyName) {
        Object pluginConfiguration;
        Plugin plugin = this.project.getPlugin("org.apache.maven.plugins:maven-compiler-plugin");
        if (plugin != null && (pluginConfiguration = plugin.getConfiguration()) instanceof Xpp3Dom) {
            return this.getNodeValue((Xpp3Dom)pluginConfiguration, propertyName);
        }
        return null;
    }

    private String getPropertyValue(String propertyName) {
        if (this.project.getProperties().containsKey(propertyName)) {
            return this.project.getProperties().get(propertyName).toString();
        }
        return null;
    }

    private String getNodeValue(Xpp3Dom dom, String ... childNames) {
        Xpp3Dom childNode = dom.getChild(childNames[0]);
        if (childNode == null) {
            return null;
        }
        if (childNames.length > 1) {
            return this.getNodeValue(childNode, Arrays.copyOfRange(childNames, 1, childNames.length));
        }
        return childNode.getValue();
    }

    private String majorVersionFor(String version) {
        if (version != null && version.startsWith("1.")) {
            return version.substring("1.".length());
        }
        return version;
    }
}

