/*
 * Copyright 2017-2024 noear.org and authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.noear.solon.maven.plugin.tools.tool;

import java.io.File;

/**
 * Factory interface used to create a {@link Layout}.
 *
 * @author Dave Syer
 * @author Phillip Webb
 */
public interface LayoutFactory {

	/**
	 * Return a {@link Layout} for the specified source file.
	 * @param source the source file
	 * @return the layout to use for the file
	 */
	Layout getLayout(File source);

}
