/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.fastjson;

import com.alibaba.fastjson.serializer.SerializerFeature;
import org.noear.solon.core.handle.Render;
import org.noear.solon.serialization.ContextSerializer;
import org.noear.solon.serialization.JsonRenderFactory;
import org.noear.solon.serialization.StringSerializerRender;
import org.noear.solon.serialization.fastjson.FastjsonRenderFactoryBase;
import org.noear.solon.serialization.prop.JsonProps;
import org.noear.solon.serialization.prop.JsonPropsUtil;

public class FastjsonRenderFactory
extends FastjsonRenderFactoryBase {
    public FastjsonRenderFactory(JsonProps jsonProps) {
        this.serializer.cfgSerializerFeatures(false, true, SerializerFeature.BrowserCompatible);
        this.applyProps(jsonProps);
    }

    public String[] mappings() {
        return new String[]{"@json"};
    }

    public Render create() {
        return new StringSerializerRender(false, (ContextSerializer)this.serializer);
    }

    public void setFeatures(SerializerFeature ... features) {
        this.serializer.cfgSerializerFeatures(true, true, features);
    }

    public void addFeatures(SerializerFeature ... features) {
        this.serializer.cfgSerializerFeatures(false, true, features);
    }

    public void removeFeatures(SerializerFeature ... features) {
        this.serializer.cfgSerializerFeatures(false, false, features);
    }

    protected void applyProps(JsonProps jsonProps) {
        if (jsonProps != null) {
            JsonPropsUtil.dateAsFormat((JsonRenderFactory)this, (JsonProps)jsonProps);
            JsonPropsUtil.dateAsTicks((JsonRenderFactory)this, (JsonProps)jsonProps);
            JsonPropsUtil.boolAsInt((JsonRenderFactory)this, (JsonProps)jsonProps);
            JsonPropsUtil.longAsString((JsonRenderFactory)this, (JsonProps)jsonProps);
            if (jsonProps.nullStringAsEmpty) {
                this.addFeatures(SerializerFeature.WriteNullStringAsEmpty);
            }
            if (jsonProps.nullBoolAsFalse) {
                this.addFeatures(SerializerFeature.WriteNullBooleanAsFalse);
            }
            if (jsonProps.nullNumberAsZero) {
                this.addFeatures(SerializerFeature.WriteNullNumberAsZero);
            }
            if (jsonProps.nullArrayAsEmpty) {
                this.addFeatures(SerializerFeature.WriteNullListAsEmpty);
            }
            if (jsonProps.nullAsWriteable) {
                this.addFeatures(SerializerFeature.WriteMapNullValue);
            }
            if (jsonProps.enumAsName) {
                this.addFeatures(SerializerFeature.WriteEnumUsingName);
            }
        }
    }
}

