/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.fury;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import org.apache.fury.Fury;
import org.apache.fury.ThreadLocalFury;
import org.apache.fury.ThreadSafeFury;
import org.apache.fury.config.Language;
import org.apache.fury.resolver.AllowListChecker;
import org.apache.fury.resolver.ClassChecker;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.serialization.ContextSerializer;
import org.noear.solon.serialization.fury.BlackListUtil;

public class FuryBytesSerializer
implements ContextSerializer<byte[]> {
    private static final String label = "application/fury";
    private final Collection<String> blackList = BlackListUtil.getBlackList();
    private final AllowListChecker blackListChecker = new AllowListChecker(AllowListChecker.CheckLevel.WARN);
    private final ThreadSafeFury fury = new ThreadLocalFury(classLoader -> {
        Fury tmp = Fury.builder().withAsyncCompilation(true).withLanguage(Language.JAVA).withRefTracking(true).requireClassRegistration(false).build();
        tmp.getClassResolver().setClassChecker((ClassChecker)this.blackListChecker);
        this.blackListChecker.addListener(tmp.getClassResolver());
        for (String key : this.blackList) {
            this.blackListChecker.disallowClass(key + "*");
        }
        return tmp;
    });

    public void addBlacklist(String classNameOrPrefix) {
        this.blackListChecker.disallowClass(classNameOrPrefix);
    }

    public String mimeType() {
        return label;
    }

    public Class<byte[]> dataType() {
        return byte[].class;
    }

    public boolean matched(Context ctx, String mime) {
        if (mime == null) {
            return false;
        }
        return mime.startsWith(label);
    }

    public String name() {
        return "fury-bytes";
    }

    public byte[] serialize(Object obj) throws IOException {
        return this.fury.serialize(obj);
    }

    public Object deserialize(byte[] data, Type toType) throws IOException {
        Class toClz;
        if (toType == null) {
            return this.fury.deserialize(data);
        }
        if (toType instanceof Class && (toClz = (Class)toType).isAnonymousClass()) {
            toType = toClz.getGenericSuperclass();
        }
        Class clz = ClassUtil.getTypeClass((Type)toType);
        return this.fury.deserializeJavaObject(data, clz);
    }

    public void serializeToBody(Context ctx, Object data) throws IOException {
        ctx.contentType(this.mimeType());
        if (data instanceof ModelAndView) {
            ctx.output(this.serialize(((ModelAndView)data).model()));
        } else {
            ctx.output(this.serialize(data));
        }
    }

    public Object deserializeFromBody(Context ctx) throws IOException {
        return this.fury.deserialize(ctx.bodyAsBytes());
    }
}

