/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.hessian;

import com.alibaba.com.caucho.hessian.io.Hessian2Input;
import com.alibaba.com.caucho.hessian.io.Hessian2Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.serialization.ContextSerializer;

public class HessianBytesSerializer
implements ContextSerializer<byte[]> {
    private static final String label = "application/hessian";

    public String mimeType() {
        return label;
    }

    public Class<byte[]> dataType() {
        return byte[].class;
    }

    public boolean matched(Context ctx, String mime) {
        if (mime == null) {
            return false;
        }
        return mime.startsWith(label);
    }

    public String name() {
        return "hessian-bytes";
    }

    public byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Hessian2Output ho = new Hessian2Output((OutputStream)out);
        ho.writeObject(obj);
        ho.close();
        return out.toByteArray();
    }

    public Object deserialize(byte[] data, Type toType) throws IOException {
        Hessian2Input hi = new Hessian2Input((InputStream)new ByteArrayInputStream(data));
        return hi.readObject();
    }

    public void serializeToBody(Context ctx, Object data) throws IOException {
        ctx.contentType(this.mimeType());
        Hessian2Output ho = new Hessian2Output(ctx.outputStream());
        if (data instanceof ModelAndView) {
            ho.writeObject((Object)((ModelAndView)data).model());
        } else {
            ho.writeObject(data);
        }
        ho.flush();
    }

    public Object deserializeFromBody(Context ctx) throws IOException {
        Hessian2Input hi = new Hessian2Input(ctx.bodyAsStream());
        return hi.readObject();
    }
}

