/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.lang.Nullable;
import org.noear.solon.serialization.ContextSerializer;

public class KryoBytesSerializer
implements ContextSerializer<byte[]> {
    private static final String label = "application/kryo";
    private final Queue<Kryo> objects = new ConcurrentLinkedQueue<Kryo>();

    protected Kryo obtain() {
        Kryo tmp = this.objects.poll();
        if (tmp == null) {
            tmp = new Kryo();
            tmp.setRegistrationRequired(false);
        }
        return tmp;
    }

    protected void free(Kryo kryo) {
        this.objects.offer(kryo);
    }

    public String mimeType() {
        return label;
    }

    public Class<byte[]> dataType() {
        return byte[].class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serialize(Object fromObj) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Kryo tmp = this.obtain();
        try (Output output = new Output((OutputStream)outputStream);){
            tmp.writeClassAndObject(output, fromObj);
        }
        finally {
            this.free(tmp);
        }
        return outputStream.toByteArray();
    }

    /*
     * Loose catch block
     */
    public Object deserialize(byte[] data, Type toType) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        Kryo tmp = this.obtain();
        try {
            try (Input input = new Input((InputStream)inputStream);){
                Object object = tmp.readClassAndObject(input);
                return object;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.free(tmp);
        }
    }

    public boolean matched(Context ctx, String mime) {
        if (mime == null) {
            return false;
        }
        return mime.startsWith(label);
    }

    public void serializeToBody(Context ctx, Object data) throws IOException {
        ctx.contentType(this.mimeType());
        if (data instanceof ModelAndView) {
            ctx.output(this.serialize(((ModelAndView)data).model()));
        } else {
            ctx.output(this.serialize(data));
        }
    }

    public Object deserializeFromBody(Context ctx, @Nullable Type bodyType) throws IOException {
        return this.deserialize(ctx.bodyAsBytes(), (Type)null);
    }
}

