/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.grizzly.websocket;

import jakarta.servlet.http.HttpServletRequest;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.glassfish.grizzly.websockets.DefaultWebSocket;
import org.noear.solon.Utils;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.net.websocket.WebSocketTimeoutBase;
import org.noear.solon.server.util.DecodeUtils;

public class WebSocketImpl
extends WebSocketTimeoutBase {
    private final DefaultWebSocket real;
    private final HttpServletRequest req;
    private InetSocketAddress remoteAddress;
    private InetSocketAddress localAddress;

    public WebSocketImpl(DefaultWebSocket real) {
        this.real = real;
        this.req = real.getUpgradeRequest();
        String uri = this.buildUri(this.req);
        this.init(URI.create(uri));
    }

    public String buildUri(HttpServletRequest req) {
        String url = req.getRequestURL().toString();
        if (Utils.isEmpty((String)req.getQueryString())) {
            return DecodeUtils.rinseUri((String)url);
        }
        if (url.contains("?")) {
            return DecodeUtils.rinseUri((String)url);
        }
        return DecodeUtils.rinseUri((String)url) + "?" + req.getQueryString();
    }

    public boolean isValid() {
        return !this.isClosed();
    }

    public boolean isSecure() {
        return this.req.isSecure();
    }

    public InetSocketAddress remoteAddress() {
        if (this.remoteAddress == null) {
            this.remoteAddress = new InetSocketAddress(this.req.getRemoteHost(), this.req.getRemotePort());
        }
        return this.remoteAddress;
    }

    public InetSocketAddress localAddress() {
        if (this.localAddress == null) {
            this.localAddress = new InetSocketAddress(this.req.getLocalAddr(), this.req.getLocalPort());
        }
        return this.localAddress;
    }

    public Future<Void> send(String text) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.real.send(text);
            this.onSend();
            future.complete(null);
        }
        catch (Throwable ex) {
            future.completeExceptionally(ex);
        }
        return future;
    }

    public Future<Void> send(ByteBuffer binary) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.real.send(binary.array());
            this.onSend();
            future.complete(null);
        }
        catch (Throwable ex) {
            future.completeExceptionally(ex);
        }
        return future;
    }

    public void close() {
        super.close();
        RunUtil.runAndTry(() -> ((DefaultWebSocket)this.real).close());
    }
}

