/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty.websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.concurrent.Future;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Session;
import org.noear.solon.boot.web.DecodeUtils;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.net.websocket.WebSocketBase;

public class WebSocketImpl
extends WebSocketBase {
    private final Session real;

    public WebSocketImpl(Session real) {
        this.real = real;
        String uri = DecodeUtils.rinseUri((String)real.getUpgradeRequest().getRequestURI().toString());
        this.init(URI.create(uri));
    }

    public boolean isValid() {
        return !this.isClosed() && this.real.isOpen();
    }

    public boolean isSecure() {
        return this.real.isSecure();
    }

    public InetSocketAddress remoteAddress() throws IOException {
        return (InetSocketAddress)this.real.getRemoteSocketAddress();
    }

    public InetSocketAddress localAddress() throws IOException {
        return (InetSocketAddress)this.real.getLocalSocketAddress();
    }

    public long getIdleTimeout() {
        return this.real.getIdleTimeout().toMillis();
    }

    public void setIdleTimeout(long idleTimeout) {
        this.real.setIdleTimeout(Duration.ofMillis(idleTimeout));
    }

    public Future<Void> send(String text) {
        Callback.Completable future = new Callback.Completable();
        this.real.sendText(text, (Callback)future);
        return future;
    }

    public Future<Void> send(ByteBuffer binary) {
        Callback.Completable future = new Callback.Completable();
        this.real.sendBinary(binary, (Callback)future);
        return future;
    }

    public void close() {
        super.close();
        RunUtil.runAndTry(() -> ((Session)this.real).close());
    }
}

