/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty.http;

import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.jetty.integration.JettyPlugin;
import org.noear.solon.core.handle.Context;
import org.noear.solon.web.servlet.SolonServletHandler;

public class JtHttpContextServletHandler
extends SolonServletHandler {
    private File _tempdir;
    private int _fileOutputBuffer = 0;
    private long _maxBodySize;
    private long _maxFileSize;

    public void init() throws ServletException {
        super.init();
        this._tempdir = (File)this.getServletContext().getAttribute("jakarta.servlet.context.tempdir");
        String fileOutputBuffer = this.getServletConfig().getInitParameter("fileOutputBuffer");
        if (fileOutputBuffer != null) {
            this._fileOutputBuffer = Integer.parseInt(fileOutputBuffer);
        }
        this._maxBodySize = ServerProps.request_maxBodySize > 0L ? ServerProps.request_maxBodySize : -1L;
        this._maxFileSize = ServerProps.request_maxFileSize > 0L ? ServerProps.request_maxFileSize : -1L;
    }

    protected void preHandle(Context ctx) {
        if (ServerProps.output_meta) {
            ctx.headerSet("Solon-Boot", JettyPlugin.solon_boot_ver());
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getContentType() != null && request.getContentType().startsWith("multipart/form-data")) {
            MultipartConfigElement config = new MultipartConfigElement(this._tempdir.getCanonicalPath(), this._maxFileSize, this._maxBodySize, this._fileOutputBuffer);
            request.setAttribute("org.eclipse.jetty.multipartConfig", (Object)config);
            if (ServerProps.request_useTempfile) {
                // empty if block
            }
        }
        super.service(request, response);
    }
}

