/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.jetty;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.eclipse.jetty.ee11.servlet.ServletContextHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.session.DefaultSessionIdManager;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.server.WebSocketUpgradeHandler;
import org.noear.solon.Solon;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.ThreadsUtil;
import org.noear.solon.server.ServerLifecycle;
import org.noear.solon.server.jetty.JettyServerBase;
import org.noear.solon.server.jetty.websocket.WebSocketConfiguratorImpl;

public class JettyServer
extends JettyServerBase
implements ServerLifecycle {
    protected Server real = null;
    protected boolean enableWebSocket;

    public void enableWebSocket(boolean enableWebSocket) {
        this.enableWebSocket = enableWebSocket;
    }

    public void start(String host, int port) throws Throwable {
        this.setup(host, port);
        this.real.start();
    }

    public void stop() throws Throwable {
        if (this.real != null) {
            this.real.stop();
            this.real = null;
        }
    }

    protected void setup(String host, int port) throws IOException {
        QueuedThreadPool threadPool = new QueuedThreadPool(this.props.getMaxThreads(this.props.isIoBound()), this.props.getCoreThreads());
        if (Solon.appIf(app -> app.cfg().isEnabledVirtualThreads())) {
            threadPool.setVirtualThreadsExecutor((Executor)ThreadsUtil.newVirtualThreadPerTaskExecutor());
        }
        this.real = new Server((ThreadPool)threadPool);
        this.real.addConnector((Connector)this.getConnector(this.real, host, port, true));
        for (Integer portAdd : this.addHttpPorts) {
            this.real.addConnector((Connector)this.getConnector(this.real, host, portAdd, false));
        }
        if (this.enableSessionState) {
            this.real.addBean((Object)new DefaultSessionIdManager(this.real));
        }
        ServletContextHandler contextHandler = this.buildHandler();
        if (this.enableWebSocket && ClassUtil.hasClass(() -> UpgradeRequest.class)) {
            WebSocketUpgradeHandler wsHandler = WebSocketUpgradeHandler.from((Server)this.real, (ContextHandler)contextHandler, (Consumer)new WebSocketConfiguratorImpl());
            contextHandler.setHandler((Handler)wsHandler);
        }
        this.real.setHandler((Handler)contextHandler);
        EventBus.publish((Object)this.real);
    }

    protected ServletContextHandler buildHandler() throws IOException {
        return this.getServletHandler();
    }
}

