/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.jetty;

import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import org.eclipse.jetty.ee11.servlet.ServletContextHandler;
import org.eclipse.jetty.ee11.servlet.ServletHolder;
import org.eclipse.jetty.ee11.servlet.SessionHandler;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.noear.solon.Utils;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.server.ServerLifecycle;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.handle.SessionProps;
import org.noear.solon.server.http.HttpServerConfigure;
import org.noear.solon.server.jetty.http.JtContainerInitializer;
import org.noear.solon.server.jetty.http.JtHttpContextServletHandler;
import org.noear.solon.server.prop.impl.HttpServerProps;
import org.noear.solon.server.ssl.SslConfig;

public abstract class JettyServerBase
implements ServerLifecycle,
HttpServerConfigure {
    protected Executor executor;
    protected HttpServerProps props = HttpServerProps.getInstance();
    protected SslConfig sslConfig = new SslConfig("http");
    protected boolean enableSessionState;
    private boolean isSecure;
    protected Set<Integer> addHttpPorts = new LinkedHashSet<Integer>();

    public boolean isSecure() {
        return this.isSecure;
    }

    public void enableSessionState(boolean enableSessionState) {
        this.enableSessionState = enableSessionState;
    }

    public void enableSsl(boolean enable, SSLContext sslContext) {
        this.sslConfig.set(enable, null);
    }

    public void addHttpPort(int port) {
        this.addHttpPorts.add(port);
    }

    public HttpServerProps getProps() {
        return this.props;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    protected ServerConnector getConnector(Server server, String host, int port, boolean autoSsl) throws RuntimeException {
        ServerConnector serverConnector;
        HttpConfiguration config = new HttpConfiguration();
        if (ServerProps.request_maxHeaderSize > 0) {
            config.setRequestHeaderSize(ServerProps.request_maxHeaderSize);
        }
        config.setSendServerVersion(false);
        config.setUriCompliance(UriCompliance.LEGACY);
        HttpConnectionFactory httpFactory = new HttpConnectionFactory(config);
        if (this.sslConfig.isSslEnable() && autoSsl) {
            String sslKeyStore = this.sslConfig.getProps().getSslKeyStore();
            String sslKeyStoreType = this.sslConfig.getProps().getSslKeyType();
            String sslKeyStorePassword = this.sslConfig.getProps().getSslKeyPassword();
            SslContextFactory.Server contextFactory = new SslContextFactory.Server();
            if (Utils.isNotEmpty((String)sslKeyStore)) {
                URL url = ResourceUtil.findResource((String)sslKeyStore);
                if (url != null) {
                    sslKeyStore = url.toString();
                }
                contextFactory.setKeyStorePath(sslKeyStore);
            }
            if (Utils.isNotEmpty((String)sslKeyStoreType)) {
                contextFactory.setKeyStoreType(sslKeyStoreType);
            }
            if (Utils.isNotEmpty((String)sslKeyStorePassword)) {
                contextFactory.setKeyStorePassword(sslKeyStorePassword);
            }
            SslConnectionFactory sslFactory = new SslConnectionFactory(contextFactory, HttpVersion.HTTP_1_1.asString());
            serverConnector = new ServerConnector(server, this.executor, null, null, -1, -1, new ConnectionFactory[]{sslFactory, httpFactory});
            this.isSecure = true;
        } else {
            serverConnector = new ServerConnector(server, this.executor, null, null, -1, -1, new ConnectionFactory[]{httpFactory});
        }
        serverConnector.setIdleTimeout(this.props.getIdleTimeoutOrDefault());
        serverConnector.setPort(port);
        if (Utils.isNotEmpty((String)host)) {
            serverConnector.setHost(host);
        }
        return serverConnector;
    }

    protected ServletContextHandler getServletHandler() throws IOException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File scratchDir = new File(tempDir.toString(), "solon-server");
        if (!scratchDir.exists()) {
            scratchDir.mkdirs();
        }
        String _tempdir = scratchDir.getAbsolutePath();
        int _fileOutputBuffer = 0x100000;
        long _maxBodySize = ServerProps.request_maxBodySize > 0L ? ServerProps.request_maxBodySize : -1L;
        long _maxFileSize = ServerProps.request_maxFileSize > 0L ? ServerProps.request_maxFileSize : -1L;
        MultipartConfigElement multipartConfig = new MultipartConfigElement(_tempdir, _maxFileSize, ServerProps.request_maxFileRequestSize(), _fileOutputBuffer);
        ServletHolder servletHolder = new ServletHolder((Servlet)new JtHttpContextServletHandler());
        servletHolder.setAsyncSupported(true);
        servletHolder.getRegistration().setMultipartConfig(multipartConfig);
        ServletContextHandler handler = new ServletContextHandler();
        handler.setContextPath("/");
        handler.addServlet(servletHolder, "/");
        if (_maxBodySize > Integer.MAX_VALUE) {
            _maxBodySize = Integer.MAX_VALUE;
        }
        handler.setMaxFormContentSize((int)_maxBodySize);
        if (ServerProps.request_useTempfile) {
            handler.setTempDirectory(scratchDir);
        }
        if (this.enableSessionState) {
            handler.setSessionHandler(new SessionHandler());
            if (SessionProps.session_timeout > 0) {
                handler.getSessionHandler().setMaxInactiveInterval(SessionProps.session_timeout);
            }
        }
        handler.addBean((Object)new JtContainerInitializer(handler.getServletContext()));
        if (!scratchDir.exists() && !scratchDir.mkdirs()) {
            throw new IOException("Unable to create scratch directory: " + scratchDir);
        }
        handler.setAttribute("jakarta.servlet.context.tempdir", (Object)scratchDir);
        return handler;
    }
}

