/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.jetty.websocket;

import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Session;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.WebSocketRouter;
import org.noear.solon.server.jetty.websocket.WebSocketImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketListenerImpl
implements Session.Listener.AutoDemanding {
    private static final Logger log = LoggerFactory.getLogger(WebSocketListenerImpl.class);
    private WebSocketImpl webSocket;
    private final WebSocketRouter webSocketRouter = WebSocketRouter.getInstance();

    public void onWebSocketOpen(Session session) {
        session.setMaxTextMessageSize(17000000L);
        this.webSocket = new WebSocketImpl(session);
        session.getUpgradeRequest().getHeaders().forEach((k, v) -> {
            if (v.size() > 0) {
                this.webSocket.param((String)k, (String)v.get(0));
            }
        });
        this.webSocketRouter.getListener().onOpen((WebSocket)this.webSocket);
    }

    public void onWebSocketBinary(ByteBuffer payload, Callback callback) {
        try {
            this.webSocketRouter.getListener().onMessage((WebSocket)this.webSocket, payload);
            callback.succeed();
        }
        catch (Throwable e) {
            this.webSocketRouter.getListener().onError((WebSocket)this.webSocket, e);
            callback.fail(e);
        }
    }

    public void onWebSocketText(String text) {
        try {
            this.webSocketRouter.getListener().onMessage((WebSocket)this.webSocket, text);
        }
        catch (Throwable e) {
            this.webSocketRouter.getListener().onError((WebSocket)this.webSocket, e);
        }
    }

    public void onWebSocketPing(ByteBuffer byteBuffer) {
        this.webSocketRouter.getListener().onPing((WebSocket)this.webSocket);
    }

    public void onWebSocketPong(ByteBuffer byteBuffer) {
        this.webSocketRouter.getListener().onPong((WebSocket)this.webSocket);
    }

    public void onWebSocketError(Throwable cause) {
        try {
            this.webSocketRouter.getListener().onError((WebSocket)this.webSocket, cause);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    public void onWebSocketClose(int statusCode, String reason, Callback callback) {
        try {
            if (this.webSocket.isClosed()) {
                return;
            }
            RunUtil.runAndTry(this.webSocket::close);
            this.webSocketRouter.getListener().onClose((WebSocket)this.webSocket);
            callback.succeed();
        }
        catch (Throwable e) {
            this.webSocketRouter.getListener().onError((WebSocket)this.webSocket, e);
            callback.fail(e);
        }
    }
}

