/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.jetty;

import jakarta.servlet.ServletContext;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import jakarta.servlet.descriptor.TaglibDescriptor;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import org.eclipse.jetty.ee11.jsp.JettyJspServlet;
import org.eclipse.jetty.ee11.servlet.ServletContextHandler;
import org.eclipse.jetty.ee11.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.PathResourceFactory;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.server.jetty.JettyServer;
import org.noear.solon.server.jetty.jsp.JspLifeCycle;
import org.noear.solon.server.jetty.jsp.JspTldLocator;

public class JettyServerAddJsp
extends JettyServer {
    @Override
    protected ServletContextHandler buildHandler() throws IOException {
        ServletContextHandler handler = this.getServletHandler();
        PathResourceFactory rf = new PathResourceFactory();
        handler.setBaseResource(rf.newResource(ResourceUtil.getResource((String)"/")));
        this.addJspSupport(handler);
        this.addTdlSupport(handler.getServletContext());
        return handler;
    }

    private void addJspSupport(ServletContextHandler handler) throws IOException {
        URLClassLoader jspClassLoader = new URLClassLoader(new URL[0], this.getClass().getClassLoader());
        handler.setClassLoader((ClassLoader)jspClassLoader);
        handler.addBean((Object)new JspLifeCycle(handler));
        ServletHolder holderJsp = new ServletHolder("jsp", JettyJspServlet.class);
        holderJsp.setInitOrder(0);
        handler.addServlet(holderJsp, "*.jsp");
    }

    private void addTdlSupport(ServletContext servletContext) throws IOException {
        Map<String, TaglibDescriptor> tagLibInfos = JspTldLocator.createTldInfos("WEB-INF", "templates");
        if (tagLibInfos.size() > 0) {
            ServletContextHandler.JspConfig jspConfig = (ServletContextHandler.JspConfig)servletContext.getJspConfigDescriptor();
            if (jspConfig == null) {
                jspConfig = new ServletContextHandler.JspConfig();
                ((ServletContextHandler.ServletContextApi)servletContext).setJspConfigDescriptor((JspConfigDescriptor)jspConfig);
            }
            for (TaglibDescriptor descriptor : tagLibInfos.values()) {
                jspConfig.addTaglibDescriptor(descriptor);
            }
        }
    }
}

