/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.jetty.websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import org.eclipse.jetty.websocket.api.Session;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.net.websocket.WebSocketBase;
import org.noear.solon.server.util.DecodeUtils;

public class WebSocketImpl
extends WebSocketBase {
    private final Session real;

    public WebSocketImpl(Session real) {
        this.real = real;
        String uri = DecodeUtils.rinseUri((String)real.getUpgradeRequest().getRequestURI().toString());
        this.init(URI.create(uri));
    }

    public boolean isValid() {
        return !this.isClosed() && this.real.isOpen();
    }

    public boolean isSecure() {
        return this.real.isSecure();
    }

    public InetSocketAddress remoteAddress() throws IOException {
        return this.real.getRemoteAddress();
    }

    public InetSocketAddress localAddress() throws IOException {
        return this.real.getLocalAddress();
    }

    public long getIdleTimeout() {
        return this.real.getIdleTimeout();
    }

    public void setIdleTimeout(long idleTimeout) {
        this.real.setIdleTimeout(idleTimeout);
    }

    public Future<Void> send(String text) {
        return this.real.getRemote().sendStringByFuture(text);
    }

    public Future<Void> send(ByteBuffer binary) {
        return this.real.getRemote().sendBytesByFuture(binary);
    }

    public void close() {
        super.close();
        RunUtil.runAndTry(() -> ((Session)this.real).close());
    }
}

