/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.jetty.http;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.MultiPartFormInputStream;
import org.noear.solon.core.handle.Context;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.jetty.http.JtHttpRequestWrapper;
import org.noear.solon.server.jetty.integration.JettyPlugin;
import org.noear.solon.web.servlet.SolonServletHandler;

public class JtHttpContextServletHandler
extends SolonServletHandler {
    private File _tempdir;

    public void init() throws ServletException {
        super.init();
        this._tempdir = (File)this.getServletContext().getAttribute("javax.servlet.context.tempdir");
    }

    protected void preHandle(Context ctx) throws IOException {
        if (ServerProps.output_meta) {
            ctx.headerSet("Solon-Server", JettyPlugin.solon_server_ver());
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getContentType() != null && request.getContentType().startsWith("multipart/form-data")) {
            MultipartConfigElement config = (MultipartConfigElement)request.getAttribute("org.eclipse.jetty.multipartConfig");
            if (ServerProps.request_useTempfile) {
                BufferedInputStream in = new BufferedInputStream((InputStream)request.getInputStream());
                String ct = request.getContentType();
                MultiPartFormInputStream multiPartParser = new MultiPartFormInputStream((InputStream)in, ct, config, this._tempdir);
                multiPartParser.setWriteFilesWithFilenames(true);
                request = new JtHttpRequestWrapper((HttpServletRequest)request, multiPartParser);
            }
        }
        super.service(request, response);
    }
}

