/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.prop.impl;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.boot.prop.ServerExecutorProps;
import org.noear.solon.boot.prop.ServerSignalProps;

@Deprecated
public abstract class BaseServerProps
implements ServerSignalProps,
ServerExecutorProps {
    private String PROP_NAME = "server.@@.name";
    private String PROP_PORT = "server.@@.port";
    private String PROP_HOST = "server.@@.host";
    private String PROP_WRAP_PORT = "server.@@.wrapPort";
    private String PROP_WRAP_HOST = "server.@@.wrapHost";
    private String PROP_IO_BOUND = "server.@@.ioBound";
    private String PROP_CORE_THREADS = "server.@@.coreThreads";
    private String PROP_MAX_THREADS = "server.@@.maxThreads";
    private String PROP_IDLE_TIMEOUT = "server.@@.idleTimeout";
    private String name;
    private int port;
    private String host;
    private int wrapPort;
    private String wrapHost;
    private boolean ioBound;
    private int coreThreads;
    private int maxThreads;
    private long idleTimeout;

    protected BaseServerProps(String signalName, int portBase) {
        this.PROP_NAME = this.PROP_NAME.replace("@@", signalName);
        this.PROP_PORT = this.PROP_PORT.replace("@@", signalName);
        this.PROP_HOST = this.PROP_HOST.replace("@@", signalName);
        this.PROP_WRAP_PORT = this.PROP_WRAP_PORT.replace("@@", signalName);
        this.PROP_WRAP_HOST = this.PROP_WRAP_HOST.replace("@@", signalName);
        this.PROP_IO_BOUND = this.PROP_IO_BOUND.replace("@@", signalName);
        this.PROP_CORE_THREADS = this.PROP_CORE_THREADS.replace("@@", signalName);
        this.PROP_MAX_THREADS = this.PROP_MAX_THREADS.replace("@@", signalName);
        this.PROP_IDLE_TIMEOUT = this.PROP_IDLE_TIMEOUT.replace("@@", signalName);
        this.initSignalProps(portBase);
        this.initExecutorProps();
    }

    private void initSignalProps(int portBase) {
        this.name = Solon.cfg().get(this.PROP_NAME);
        this.port = Solon.cfg().getInt(this.PROP_PORT, 0);
        this.host = Solon.cfg().get(this.PROP_HOST);
        this.wrapPort = Solon.cfg().getInt(this.PROP_WRAP_PORT, 0);
        this.wrapHost = Solon.cfg().get(this.PROP_WRAP_HOST);
        if (this.port < 1) {
            this.port = portBase + Solon.cfg().serverPort();
        }
        if (Utils.isEmpty((String)this.host)) {
            this.host = Solon.cfg().serverHost();
        }
        if (this.wrapPort < 1) {
            this.wrapPort = Solon.cfg().serverWrapPort(true);
            if (this.wrapPort < 1) {
                this.wrapPort = this.port;
            }
        }
        if (Utils.isEmpty((String)this.wrapHost)) {
            this.wrapHost = Solon.cfg().serverWrapHost(true);
            if (Utils.isEmpty((String)this.wrapHost)) {
                this.wrapHost = this.host;
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getWrapPort() {
        return this.wrapPort;
    }

    @Override
    public String getWrapHost() {
        return this.wrapHost;
    }

    private void initExecutorProps() {
        String maxThreadsStr;
        this.ioBound = Solon.cfg().getBool(this.PROP_IO_BOUND, true);
        this.idleTimeout = Solon.cfg().getLong(this.PROP_IDLE_TIMEOUT, 0L);
        String coreThreadsStr = Solon.cfg().get(this.PROP_CORE_THREADS);
        if (Utils.isNotEmpty((String)coreThreadsStr)) {
            this.coreThreads = coreThreadsStr.startsWith("x") ? (coreThreadsStr.length() > 1 ? this.getCoreNum() * Integer.parseInt(coreThreadsStr.substring(1)) : 0) : Integer.parseInt(coreThreadsStr);
        }
        if (Utils.isNotEmpty((String)(maxThreadsStr = Solon.cfg().get(this.PROP_MAX_THREADS)))) {
            this.maxThreads = maxThreadsStr.startsWith("x") ? (maxThreadsStr.length() > 1 ? this.getCoreNum() * Integer.parseInt(maxThreadsStr.substring(1)) : 0) : Integer.parseInt(maxThreadsStr);
        }
    }

    @Override
    public boolean isIoBound() {
        return this.ioBound;
    }

    private int getCoreNum() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public int getCoreThreads() {
        if (this.coreThreads > 0) {
            return this.coreThreads;
        }
        return Math.max(this.getCoreNum(), 2);
    }

    @Override
    public int getMaxThreads(boolean isIoBound) {
        if (this.maxThreads > 0) {
            return this.maxThreads;
        }
        if (isIoBound) {
            return this.getCoreThreads() * 32;
        }
        return this.getCoreThreads() * 8;
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public long getIdleTimeoutOrDefault() {
        if (this.idleTimeout > 0L) {
            return this.idleTimeout;
        }
        return 300000L;
    }
}

