/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.prop.impl;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.server.prop.impl.BaseServerProps;

public class HttpServerProps
extends BaseServerProps {
    public static HttpServerProps getInstance() {
        return (HttpServerProps)Solon.context().attachOf(HttpServerProps.class, HttpServerProps::new);
    }

    public HttpServerProps() {
        super("http", 0);
    }

    public String buildHttpServerUrl(boolean isSecure) {
        StringBuilder buf = new StringBuilder();
        buf.append(isSecure ? "https" : "http");
        buf.append("://");
        if (Utils.isEmpty((String)this.getHost())) {
            buf.append("localhost");
        } else {
            buf.append(this.getHost());
        }
        buf.append(":");
        buf.append(this.getPort());
        return buf.toString();
    }

    public String buildWsServerUrl(boolean isSecure) {
        StringBuilder buf = new StringBuilder();
        buf.append(isSecure ? "wws" : "ws");
        buf.append("://");
        if (Utils.isEmpty((String)this.getHost())) {
            buf.append("localhost");
        } else {
            buf.append(this.getHost());
        }
        buf.append(":");
        buf.append(this.getPort());
        return buf.toString();
    }
}

