/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.sessionstate.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.impl.DefaultClaims;
import java.util.Collection;
import java.util.ServiceConfigurationError;
import org.noear.solon.Utils;
import org.noear.solon.boot.web.SessionStateBase;
import org.noear.solon.core.handle.Context;
import org.noear.solon.sessionstate.jwt.JwtSessionProps;
import org.noear.solon.sessionstate.jwt.JwtUtils;

public class JwtSessionState
extends SessionStateBase {
    private String sessionId;
    private Claims sessionMap;
    private String sessionToken;

    protected JwtSessionState(Context ctx) {
        super(ctx);
    }

    public boolean replaceable() {
        return false;
    }

    public long creationTime() {
        return this.ctx.sessionAsLong("SESSION_CREATION_TIME", 0L);
    }

    public long lastAccessTime() {
        return this.ctx.sessionAsLong("SESSION_LAST_ACCESS_TIME", 0L);
    }

    public String sessionId() {
        if (JwtSessionProps.getInstance().allowUseHeader) {
            return "";
        }
        if (this.sessionId == null) {
            this.sessionId = this.sessionIdGet(false);
        }
        return this.sessionId;
    }

    public String sessionChangeId() {
        if (JwtSessionProps.getInstance().allowUseHeader) {
            return "";
        }
        this.sessionId = this.sessionIdGet(true);
        return this.sessionId;
    }

    public Collection<String> sessionKeys() {
        return this.sessionMap.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Claims sessionMap() {
        if (this.sessionMap == null) {
            Utils.locker().lock();
            try {
                if (this.sessionMap == null) {
                    Claims claims;
                    this.sessionMap = new DefaultClaims();
                    String sesId = this.sessionId();
                    String token = this.jwtGet();
                    if (Utils.isNotEmpty((String)token) && token.contains(".") && (claims = JwtUtils.parseJwt(token)) != null && (JwtSessionProps.getInstance().allowUseHeader || sesId.equals(claims.getId()))) {
                        if (JwtSessionProps.getInstance().allowExpire) {
                            if (claims.getExpiration() != null && claims.getExpiration().getTime() > System.currentTimeMillis()) {
                                this.sessionMap = claims;
                            }
                        } else {
                            this.sessionMap = claims;
                        }
                    }
                    this.sessionToken = null;
                }
            }
            finally {
                Utils.locker().unlock();
            }
        }
        return this.sessionMap;
    }

    public <T> T sessionGet(String key, Class<T> clz) {
        return (T)this.sessionMap().get((Object)key);
    }

    public void sessionSet(String key, Object val) {
        if (val == null) {
            this.sessionRemove(key);
        } else {
            this.sessionMap().put((Object)key, val);
            this.sessionToken = null;
        }
    }

    public void sessionRemove(String key) {
        this.sessionMap().remove((Object)key);
        this.sessionToken = null;
    }

    public void sessionClear() {
        this.sessionMap().clear();
        this.sessionToken = null;
    }

    public void sessionReset() {
        this.sessionClear();
        this.sessionChangeId();
    }

    public void sessionRefresh() {
        if (JwtSessionProps.getInstance().allowUseHeader) {
            return;
        }
        String sid = this.sessionIdPush();
        if (!Utils.isEmpty((String)sid)) {
            long now = System.currentTimeMillis();
            if (this.sessionGet("SESSION_CREATION_TIME") == null) {
                this.sessionSet("SESSION_CREATION_TIME", now);
            }
        }
    }

    public void sessionPublish() {
        if (JwtSessionProps.getInstance().allowAutoIssue) {
            String token;
            String sid = this.sessionId();
            if (!Utils.isEmpty((String)sid)) {
                long now = System.currentTimeMillis();
                this.sessionSet("SESSION_LAST_ACCESS_TIME", now);
            }
            if (Utils.isNotEmpty((String)(token = this.sessionToken()))) {
                this.jwtSet(token);
            }
        }
    }

    public String sessionToken() {
        Claims tmp;
        if (this.sessionToken == null && (tmp = this.sessionMap()) != null) {
            if (JwtSessionProps.getInstance().allowUseHeader && tmp.size() == 0) {
                this.sessionToken = "";
            }
            if (this.sessionToken == null) {
                String skey = this.sessionId();
                if (JwtSessionProps.getInstance().allowUseHeader || Utils.isNotEmpty((String)skey)) {
                    tmp.setId(skey);
                    try {
                        this.sessionToken = JwtSessionProps.getInstance().allowExpire ? JwtUtils.buildJwt(tmp, (long)_expiry * 1000L) : JwtUtils.buildJwt(tmp, 0L);
                    }
                    catch (ServiceConfigurationError e) {
                        this.sessionToken = "";
                    }
                }
            }
        }
        return this.sessionToken;
    }

    protected String jwtGet() {
        if (JwtSessionProps.getInstance().allowUseHeader) {
            return this.ctx.header(JwtSessionProps.getInstance().name);
        }
        return this.cookieGet(JwtSessionProps.getInstance().name);
    }

    protected void jwtSet(String token) {
        if (JwtSessionProps.getInstance().allowUseHeader) {
            this.ctx.headerSet(JwtSessionProps.getInstance().name, token);
        } else {
            this.cookieSet(JwtSessionProps.getInstance().name, token);
        }
        this.ctx.attrSet(JwtSessionProps.getInstance().name, (Object)token);
    }
}

