/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.statemachine;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.noear.solon.core.util.Assert;
import org.noear.solon.lang.Preview;
import org.noear.solon.statemachine.Event;
import org.noear.solon.statemachine.EventContext;
import org.noear.solon.statemachine.State;
import org.noear.solon.statemachine.StateTransition;
import org.noear.solon.statemachine.StateTransitionContext;
import org.noear.solon.statemachine.StateTransitionDecl;

@Preview(value="3.4")
public class StateMachine<S extends State, E extends Event, T> {
    private final List<StateTransition<S, E, T>> transitions = new ArrayList<StateTransition<S, E, T>>();
    private final ReentrantLock LOCKER = new ReentrantLock();

    public void addTransition(Consumer<StateTransitionDecl<S, E, T>> declaration) {
        Assert.notNull(declaration, (String)"The declaration cannot be null");
        StateTransitionDecl decl = new StateTransitionDecl();
        declaration.accept(decl);
        decl.check();
        this.transitions.add(new StateTransition(decl));
    }

    public S sendEvent(E event, EventContext<S, T> eventContext) {
        Assert.notNull(event, (String)"The event cannot be null");
        Assert.notNull(eventContext, (String)"The eventContext cannot be null");
        this.LOCKER.lock();
        try {
            for (StateTransition<S, E, T> transition : this.transitions) {
                if (!transition.matches(event, eventContext)) continue;
                S to = transition.getTo();
                transition.execute(new StateTransitionContext<S, E, T>(eventContext.getCurrentState(), to, event, eventContext.getPayload()));
                S s = to;
                return s;
            }
            throw new IllegalStateException("Unable to transition from state '" + eventContext.getCurrentState() + "' and event '" + event + "' to a valid new state");
        }
        finally {
            this.LOCKER.unlock();
        }
    }
}

