/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.test;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.aspect.BeanProxy;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.event.AppInitEndEvent;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.test.SolonTest;
import org.noear.solon.test.annotation.TestPropertySource;
import org.noear.solon.test.annotation.TestRollback;
import org.noear.solon.test.data.TestRollbackInterceptor;

class RunnerUtils {
    public static final String TAG_classpath = "classpath:";
    private static Map<Class<?>, AopContext> appCached = new HashMap();

    RunnerUtils() {
    }

    public static Class<?> getMainClz(SolonTest anno, Class<?> klass) {
        if (anno == null) {
            return klass;
        }
        Class<?> mainClz = anno.value();
        if (mainClz == Void.class) {
            mainClz = anno.classes();
        }
        if (mainClz == Void.class) {
            return klass;
        }
        return mainClz;
    }

    public static Method getMainMethod(Class<?> mainClz) {
        try {
            return mainClz.getMethod("main", String[].class);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void addPropertySource(AopContext context, TestPropertySource propertySource) {
        if (propertySource == null) {
            return;
        }
        for (String uri : propertySource.value()) {
            if (uri.startsWith(TAG_classpath)) {
                context.cfg().loadAdd(uri.substring(TAG_classpath.length()));
                continue;
            }
            try {
                context.cfg().loadAdd(new File(uri).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Object initTestTarget(AopContext aopContext, Object tmp) {
        aopContext.beanInject(tmp);
        BeanWrap beanWrap = new BeanWrap(aopContext, tmp.getClass(), tmp);
        aopContext.beanExtract(beanWrap);
        tmp = BeanProxy.getGlobal().getProxy(aopContext, tmp);
        return tmp;
    }

    public static AopContext initRunner(Class<?> klass) throws Throwable {
        SolonTest anno = klass.getAnnotation(SolonTest.class);
        if (anno != null) {
            Class<?> mainClz;
            if (anno.properties().length > 0) {
                for (String tmp : anno.properties()) {
                    String[] kv = tmp.split("=");
                    if (kv.length != 2) continue;
                    System.setProperty(kv[0], kv[1]);
                }
            }
            ArrayList<String> argsAry = new ArrayList<String>();
            if (anno.args().length > 0) {
                argsAry.addAll(Arrays.asList(anno.args()));
            }
            if (anno.debug()) {
                argsAry.add("-debug=1");
            }
            if (Utils.isNotEmpty((String)anno.env())) {
                argsAry.add("-env=" + anno.env());
            }
            if (appCached.containsKey(mainClz = RunnerUtils.getMainClz(anno, klass))) {
                return appCached.get(mainClz);
            }
            AopContext aopContext = RunnerUtils.startDo(mainClz, argsAry, klass);
            appCached.put(mainClz, aopContext);
            if (anno.delay() > 0) {
                try {
                    Thread.sleep(anno.delay() * 1000);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return aopContext;
        }
        ArrayList<String> argsAry = new ArrayList<String>();
        argsAry.add("-debug=1");
        return RunnerUtils.startDo(klass, argsAry, klass);
    }

    private static AopContext startDo(Class<?> mainClz, List<String> argsAry, Class<?> klass) throws Throwable {
        if (mainClz == klass) {
            argsAry.add("isolated=1");
            String[] args = argsAry.toArray(new String[argsAry.size()]);
            SolonApp app = new SolonApp(mainClz, NvMap.from((String[])args));
            Solon.startIsolatedApp((SolonApp)app, x -> RunnerUtils.initDo(x, klass));
            return app.context();
        }
        Method main = RunnerUtils.getMainMethod(mainClz);
        if (main != null && Modifier.isStatic(main.getModifiers())) {
            String[] args = argsAry.toArray(new String[argsAry.size()]);
            RunnerUtils.initDo(null, klass);
            main.invoke(null, new Object[]{args});
            return Solon.context();
        }
        argsAry.add("isolated=1");
        String[] args = argsAry.toArray(new String[argsAry.size()]);
        SolonApp app = new SolonApp(mainClz, NvMap.from((String[])args));
        Solon.startIsolatedApp((SolonApp)app, x -> RunnerUtils.initDo(x, klass));
        return app.context();
    }

    private static void initDo(SolonApp app, Class<?> klass) {
        TestPropertySource propAnno = klass.getAnnotation(TestPropertySource.class);
        if (app == null) {
            EventBus.subscribe(AppInitEndEvent.class, event -> {
                RunnerUtils.addPropertySource(event.context(), propAnno);
                event.context().beanAroundAdd(TestRollback.class, (Interceptor)new TestRollbackInterceptor(), 120);
            });
        } else {
            RunnerUtils.addPropertySource(app.context(), propAnno);
            app.context().beanAroundAdd(TestRollback.class, (Interceptor)new TestRollbackInterceptor(), 120);
        }
    }
}

