/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.test.aot;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.noear.solon.aot.hint.ExecutableHint;
import org.noear.solon.aot.hint.MemberCategory;
import org.noear.solon.aot.hint.ReflectionHints;
import org.noear.solon.core.util.ReflectUtil;
import org.noear.solon.test.aot.RuntimeNativeMetadataAssert;

public class NativeMetadataReflectAssert
extends RuntimeNativeMetadataAssert {
    public void hasType(Class<?> type) {
        NativeMetadataReflectAssert.assertTrue(this.hasType0(type), String.format("type '%s' not found in native metadata", type.getName()));
    }

    public void hasMemberCategories(Class<?> type, MemberCategory ... memberCategories) {
        NativeMetadataReflectAssert.notEmpty(memberCategories, "'memberCategories' must not be empty");
        NativeMetadataReflectAssert.assertTrue(((ReflectionHints)NativeMetadataReflectAssert.getMetadata().getReflection().get(ReflectUtil.getClassName(type))).getMemberCategories().containsAll(Arrays.asList(memberCategories)), "memberCategories not all found in native metadata");
    }

    public void hasMemberCategories(String className, MemberCategory ... memberCategories) {
        NativeMetadataReflectAssert.notEmpty(memberCategories, "'memberCategories' must not be empty");
        NativeMetadataReflectAssert.assertTrue(((ReflectionHints)NativeMetadataReflectAssert.getMetadata().getReflection().get(className)).getMemberCategories().containsAll(Arrays.asList(memberCategories)), "memberCategories not all found in native metadata");
    }

    public void hasMethod(Method method) {
        NativeMetadataReflectAssert.notNull(method, "'method' must not be null");
        NativeMetadataReflectAssert.assertTrue(this.hasMethod0(method), String.format("method '%s' not found in native metadata", method.getName()));
    }

    public void hasMethod(Class<?> type, String methodName) {
        NativeMetadataReflectAssert.notNull(type, "'type' must not be null");
        NativeMetadataReflectAssert.hasText(methodName, "'methodName' must not be empty");
        Method method = NativeMetadataReflectAssert.getMethod(type, methodName);
        NativeMetadataReflectAssert.assertTrue(this.hasMethod0(method), String.format("method '%s' not found in native metadata", method.getName()));
    }

    public void hasMethod(String className, String methodName) throws ClassNotFoundException {
        NativeMetadataReflectAssert.hasText(className, "'className' must not be empty");
        NativeMetadataReflectAssert.hasText(methodName, "'methodName' must not be empty");
        this.hasMethod(Class.forName(className), methodName);
    }

    public void hasField(Field field) {
        NativeMetadataReflectAssert.notNull(field, "'field' must not be null");
        NativeMetadataReflectAssert.assertTrue(this.hasField0(field), String.format("field '%s' on class %s not found in native metadata", field.getName(), field.getDeclaringClass().getName()));
    }

    public void hasField(Class<?> type, String fieldName) {
        NativeMetadataReflectAssert.notNull(type, "'type' must not be null");
        NativeMetadataReflectAssert.hasText(fieldName, "'fieldName' must not be empty");
        Field field = NativeMetadataReflectAssert.findField(type, fieldName);
        NativeMetadataReflectAssert.notNull(field, String.format("field '%s' not found in class %s", fieldName, type.getName()));
        NativeMetadataReflectAssert.assertTrue(this.hasField0(field), String.format("field '%s' on class %s not found in native metadata", field.getName(), field.getDeclaringClass().getName()));
    }

    public void hasField(String className, String fieldName) throws ClassNotFoundException {
        NativeMetadataReflectAssert.hasText(className, "'className' must not be empty");
        NativeMetadataReflectAssert.hasText(fieldName, "'fieldName' must not be empty");
        this.hasField(Class.forName(className), fieldName);
    }

    public boolean hasType0(Class<?> type) {
        NativeMetadataReflectAssert.notNull(type, "'type' must not be null");
        ReflectionHints reflectionHints = (ReflectionHints)NativeMetadataReflectAssert.getMetadata().getReflection().get(ReflectUtil.getClassName(type));
        return reflectionHints != null;
    }

    private boolean hasMethod0(Method method) {
        if (method == null) {
            return false;
        }
        ReflectionHints reflectionHints = (ReflectionHints)NativeMetadataReflectAssert.getMetadata().getReflection().get(ReflectUtil.getClassName(method.getDeclaringClass()));
        if (reflectionHints == null) {
            return false;
        }
        if (reflectionHints.getMethods() == null) {
            return false;
        }
        return reflectionHints.getMethods().stream().anyMatch(executableHint -> this.testMethodEquals((ExecutableHint)executableHint, method));
    }

    public boolean hasField0(Field field) {
        if (field == null) {
            return false;
        }
        ReflectionHints reflectionHints = (ReflectionHints)NativeMetadataReflectAssert.getMetadata().getReflection().get(ReflectUtil.getClassName(field.getDeclaringClass()));
        if (reflectionHints == null) {
            return false;
        }
        if (reflectionHints.getFields() == null) {
            return false;
        }
        return reflectionHints.getFields().contains(field.getName());
    }

    public boolean hasConstructor(Constructor<?> constructor) {
        if (constructor == null) {
            return false;
        }
        ReflectionHints reflectionHints = (ReflectionHints)NativeMetadataReflectAssert.getMetadata().getReflection().get(ReflectUtil.getClassName(constructor.getDeclaringClass()));
        if (reflectionHints == null) {
            return false;
        }
        if (reflectionHints.getConstructors() == null) {
            return false;
        }
        return reflectionHints.getConstructors().stream().anyMatch(executableHint -> this.testMethodEquals((ExecutableHint)executableHint, constructor));
    }

    private boolean testMethodEquals(ExecutableHint executableHint, Executable executable) {
        boolean nameIsEqual = executable instanceof Constructor ? executableHint.getName().equals("<init>") : executableHint.getName().equals(executable.getName());
        if (!nameIsEqual) {
            return false;
        }
        if (executableHint.getParameterTypes() == null && executable.getParameterCount() == 0) {
            return true;
        }
        if (executableHint.getParameterTypes().size() == executable.getParameterCount()) {
            for (int i = 0; i < executableHint.getParameterTypes().size(); ++i) {
                if (((String)executableHint.getParameterTypes().get(i)).equals(ReflectUtil.getClassName(executable.getParameterTypes()[i].getDeclaringClass()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

