/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.test.data;

import java.util.concurrent.atomic.AtomicReference;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.core.route.RouterInterceptor;
import org.noear.solon.core.util.RunnableEx;
import org.noear.solon.data.annotation.Tran;
import org.noear.solon.data.annotation.TranAnno;
import org.noear.solon.data.tran.TranUtils;
import org.noear.solon.test.annotation.Rollback;
import org.noear.solon.test.data.RollbackException;
import org.noear.solon.test.data.RollbackRouterInterceptor;

public class RollbackInterceptor
implements Interceptor {
    public Object doIntercept(Invocation inv) throws Throwable {
        if (Solon.app() == null) {
            return inv.invoke();
        }
        AtomicReference valRef = new AtomicReference();
        Rollback anno = (Rollback)inv.getMethodAnnotation(Rollback.class);
        if (anno == null) {
            anno = (Rollback)inv.getTargetAnnotation(Rollback.class);
        }
        if (anno == null || !anno.value()) {
            return inv.invoke();
        }
        RollbackInterceptor.rollbackDo(() -> valRef.set(inv.invoke()));
        return valRef.get();
    }

    public static void rollbackDo(RunnableEx runnable) throws Throwable {
        block6: {
            try {
                Solon.app().chainManager().addInterceptorIfAbsent((RouterInterceptor)RollbackRouterInterceptor.getInstance(), Integer.MAX_VALUE);
                TranUtils.execute((Tran)new TranAnno(), () -> {
                    runnable.run();
                    throw new RollbackException();
                });
            }
            catch (Throwable e) {
                e = Utils.throwableUnwrap((Throwable)e);
                if (e instanceof RollbackException) {
                    System.out.println("@Rollback: the transaction has been rolled back!");
                    break block6;
                }
                throw e;
            }
            finally {
                Solon.app().chainManager().removeInterceptor(RollbackRouterInterceptor.class);
            }
        }
    }
}

