/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.view.freemarker;

import freemarker.cache.CacheStorage;
import freemarker.cache.MruCacheStorage;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateNotFoundException;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import org.noear.solon.Solon;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.core.util.SupplierEx;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.util.DebugUtils;
import org.noear.solon.view.ViewConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkerRender
implements Render {
    static final Logger log = LoggerFactory.getLogger(FreemarkerRender.class);
    private final ClassLoader classLoader;
    private final String viewPrefix;
    private Configuration provider;
    private Configuration providerOfDebug;

    public Configuration getProvider() {
        return this.provider;
    }

    public Configuration getProviderOfDebug() {
        return this.providerOfDebug;
    }

    public FreemarkerRender() {
        this((ClassLoader)AppClassLoader.global(), null);
    }

    public FreemarkerRender(ClassLoader classLoader) {
        this(classLoader, null);
    }

    public FreemarkerRender(ClassLoader classLoader, String viewPrefix) {
        this.classLoader = classLoader;
        this.viewPrefix = viewPrefix == null ? ViewConfig.getViewPrefix() : viewPrefix;
        this.forDebug();
        this.forRelease();
    }

    private void forDebug() {
        if (!Solon.cfg().isDebugMode()) {
            return;
        }
        if (!Solon.cfg().isFilesMode()) {
            return;
        }
        if (ResourceUtil.hasFile((String)this.viewPrefix)) {
            return;
        }
        if (this.providerOfDebug != null) {
            return;
        }
        File dir = DebugUtils.getDebugLocation((ClassLoader)this.classLoader, (String)this.viewPrefix);
        if (dir == null) {
            return;
        }
        this.providerOfDebug = new Configuration(Configuration.VERSION_2_3_28);
        this.providerOfDebug.setNumberFormat("#");
        this.providerOfDebug.setDefaultEncoding("utf-8");
        try {
            if (dir.exists()) {
                this.providerOfDebug.setDirectoryForTemplateLoading(dir);
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    private void forRelease() {
        if (this.provider != null) {
            return;
        }
        this.provider = new Configuration(Configuration.VERSION_2_3_28);
        this.provider.setNumberFormat("#");
        this.provider.setDefaultEncoding("utf-8");
        try {
            if (ResourceUtil.hasFile((String)this.viewPrefix)) {
                URL dir = ResourceUtil.findResource((ClassLoader)this.classLoader, (String)this.viewPrefix, (boolean)false);
                this.provider.setDirectoryForTemplateLoading(new File(dir.getFile()));
            } else {
                this.provider.setClassLoaderForTemplateLoading(this.classLoader, this.viewPrefix);
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        this.provider.setCacheStorage((CacheStorage)new MruCacheStorage(0, Integer.MAX_VALUE));
    }

    public <T extends TemplateDirectiveModel> void putDirective(String name, T obj) {
        this.putVariable(name, obj);
    }

    public void putVariable(String name, Object value) {
        try {
            this.provider.setSharedVariable(name, value);
            if (this.providerOfDebug != null) {
                this.providerOfDebug.setSharedVariable(name, value);
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public String[] mappings() {
        return new String[]{".ftl", this.getClass().getSimpleName(), this.getClass().getName()};
    }

    public void render(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return;
        }
        if (obj instanceof ModelAndView) {
            this.doRender((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> ctx.outputStream()));
        } else {
            ctx.output(obj.toString());
        }
    }

    public String renderAndReturn(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ModelAndView) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.doRender((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> outputStream));
            return outputStream.toString();
        }
        return obj.toString();
    }

    protected void doRender(ModelAndView mv, Context ctx, SupplierEx<OutputStream> outputStream) throws Throwable {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType("text/html;charset=UTF-8");
        }
        if (ViewConfig.isOutputMeta()) {
            ctx.headerSet("Solon-View", "FreemarkerRender");
        }
        mv.putIfAbsent("context", (Object)ctx);
        Template template = null;
        if (this.providerOfDebug != null) {
            try {
                template = this.providerOfDebug.getTemplate(mv.view(), Solon.encoding());
            }
            catch (TemplateNotFoundException templateNotFoundException) {
                // empty catch block
            }
        }
        if (template == null) {
            template = this.provider.getTemplate(mv.view(), Solon.encoding());
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream.get(), ServerProps.response_encoding));
        template.process((Object)mv.model(), (Writer)writer);
        writer.flush();
    }
}

