/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.cors;

import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.MethodType;

public abstract class AbstractCross<T extends AbstractCross> {
    protected int maxAge = 3600;
    protected String allowedOrigins = "*";
    protected String allowedMethods = "*";
    protected String allowedHeaders = "*";
    protected boolean allowCredentials = true;
    protected String exposedHeaders;

    public T maxAge(int maxAge) {
        if (maxAge >= 0) {
            this.maxAge = maxAge;
        }
        return (T)this;
    }

    public T allowedOrigins(String allowOrigin) {
        if (allowOrigin != null) {
            this.allowedOrigins = allowOrigin;
        }
        return (T)this;
    }

    public T allowedMethods(String allowMethods) {
        this.allowedMethods = allowMethods;
        return (T)this;
    }

    public T allowedHeaders(String allowHeaders) {
        this.allowedHeaders = allowHeaders;
        return (T)this;
    }

    public T allowCredentials(boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
        return (T)this;
    }

    public T exposedHeaders(String exposeHeaders) {
        this.exposedHeaders = exposeHeaders;
        return (T)this;
    }

    protected void doHandle(Context ctx) throws Throwable {
        if (ctx.getHandled()) {
            return;
        }
        String origin = ctx.header("Origin");
        if (Utils.isEmpty((String)origin)) {
            return;
        }
        ctx.headerSet("Access-Control-Max-Age", String.valueOf(this.maxAge));
        if (Utils.isNotEmpty((String)this.allowedHeaders)) {
            if ("*".equals(this.allowedHeaders)) {
                String requestHeaders = ctx.header("Access-Control-Request-Headers");
                if (Utils.isNotEmpty((String)requestHeaders)) {
                    ctx.headerSet("Access-Control-Allow-Headers", requestHeaders);
                }
            } else {
                ctx.headerSet("Access-Control-Allow-Headers", this.allowedHeaders);
            }
        }
        if (Utils.isNotEmpty((String)this.allowedMethods)) {
            if ("*".equals(this.allowedMethods)) {
                String requestMethod = ctx.header("Access-Control-Request-Method");
                if (Utils.isEmpty((String)requestMethod)) {
                    requestMethod = ctx.method();
                }
                if (Utils.isNotEmpty((String)requestMethod)) {
                    ctx.headerSet("Access-Control-Allow-Methods", requestMethod);
                }
            } else {
                ctx.headerSet("Access-Control-Allow-Methods", this.allowedMethods);
            }
        }
        if (Utils.isNotEmpty((String)this.allowedOrigins) && ("*".equals(this.allowedOrigins) || this.allowedOrigins.contains(origin))) {
            ctx.headerSet("Access-Control-Allow-Origin", origin);
        }
        if (this.allowCredentials) {
            ctx.headerSet("Access-Control-Allow-Credentials", "true");
        }
        if (Utils.isNotEmpty((String)this.exposedHeaders)) {
            ctx.headerSet("Access-Control-Expose-Headers", this.exposedHeaders);
        }
        if (MethodType.OPTIONS.name.equalsIgnoreCase(ctx.method())) {
            ctx.setHandled(true);
        }
    }
}

