/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.cors;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.FilterChain;
import org.noear.solon.web.cors.CrossHandler;
import org.noear.solon.web.cors.annotation.CrossOrigin;

public class CrossOriginInterceptor
implements Filter {
    private Map<CrossOrigin, CrossHandler> handlerMap = new HashMap<CrossOrigin, CrossHandler>();
    private final ReentrantLock SYNC_LOCK = new ReentrantLock();

    public void doFilter(Context ctx, FilterChain chain) throws Throwable {
        if (ctx.getHandled()) {
            return;
        }
        Action action = ctx.action();
        if (action != null) {
            CrossOrigin anno = (CrossOrigin)action.method().getAnnotation(CrossOrigin.class);
            if (anno == null) {
                anno = (CrossOrigin)action.controller().annotationGet(CrossOrigin.class);
            }
            if (anno == null) {
                return;
            }
            this.handleDo(ctx, anno);
        }
        chain.doFilter(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDo(Context ctx, CrossOrigin anno) throws Throwable {
        CrossHandler handler = this.handlerMap.get(anno);
        if (handler == null) {
            this.SYNC_LOCK.lock();
            try {
                handler = this.handlerMap.get(anno);
                if (handler == null) {
                    handler = new CrossHandler(anno);
                    this.handlerMap.put(anno, handler);
                }
            }
            finally {
                this.SYNC_LOCK.unlock();
            }
        }
        handler.handle(ctx);
    }
}

