/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.rx.integration;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Context;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionReactiveSubscriber
implements Subscriber {
    static final Logger log = LoggerFactory.getLogger(ActionReactiveSubscriber.class);
    private Context ctx;
    private Action action;
    private boolean isMultiple;
    private boolean isStreamX;
    private List<Object> list;
    private boolean isFirst;

    public ActionReactiveSubscriber(Context ctx, Action action, boolean isMultiple) {
        this.ctx = ctx;
        this.action = action;
        this.isMultiple = isMultiple;
        this.isStreamX = ctx.contentTypeNew() != null ? ctx.contentTypeNew().startsWith("application/x-ndjson") : false;
        if (!this.isStreamX) {
            this.list = new ArrayList<Object>();
        }
    }

    public void onSubscribe(Subscription subscription) {
        this.isFirst = true;
        this.ctx.asyncStart(-1L, null, () -> {
            if (this.isMultiple) {
                subscription.request(Long.MAX_VALUE);
            } else {
                subscription.request(1L);
            }
        });
    }

    public void onNext(Object o) {
        try {
            if (this.isStreamX) {
                try {
                    if (!this.isFirst) {
                        this.ctx.output("\n");
                    }
                    this.action.render(o, this.ctx, true);
                }
                catch (Throwable e) {
                    log.warn(e.getMessage(), e);
                }
            } else {
                this.list.add(o);
            }
        }
        finally {
            this.isFirst = false;
        }
    }

    public void onError(Throwable e) {
        try {
            this.action.render((Object)e, this.ctx, false);
        }
        catch (Throwable e2) {
            this.ctx.status(500);
            log.warn(e.getMessage(), e);
        }
        finally {
            this.onComplete();
        }
    }

    public void onComplete() {
        if (this.ctx.asyncSupported()) {
            try {
                if (!this.isStreamX) {
                    if (this.isMultiple) {
                        this.action.render(this.list, this.ctx, false);
                    } else if (this.list.size() > 0) {
                        this.action.render(this.list.get(0), this.ctx, false);
                    }
                }
            }
            catch (Throwable e) {
                log.warn(e.getMessage(), e);
            }
            finally {
                this.ctx.asyncComplete();
            }
        }
    }
}

