/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.sse;

import org.noear.solon.Solon;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Render;
import org.noear.solon.web.sse.SseEvent;

public class SseRender
implements Render {
    private static final SseRender instance = new SseRender();

    public static SseRender getInstance() {
        return instance;
    }

    public boolean matched(Context ctx, String accept) {
        if (accept == null) {
            return false;
        }
        return accept.startsWith("text/event-stream");
    }

    public String renderAndReturn(Object data, Context ctx) throws Throwable {
        SseEvent event;
        if (data instanceof SseEvent) {
            event = (SseEvent)data;
        } else if (data instanceof String) {
            event = new SseEvent().data(data);
        } else {
            String json = Solon.app().renderOfJson().renderAndReturn(data, ctx);
            event = new SseEvent().data(json);
        }
        return event.toString();
    }

    public void render(Object data, Context ctx) throws Throwable {
        if (!ctx.isHeadersSent()) {
            ctx.contentType("text/event-stream;charset=UTF-8");
        }
        ctx.output(this.renderAndReturn(data, ctx));
    }
}

