/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.aspect;

import java.lang.reflect.InvocationHandler;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.aspect.BeanProxy;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.util.ScanUtil;

public class AspectUtil {
    private static Set<Class<?>> tryAttachCached = new HashSet();

    public static boolean binding(BeanWrap bw, String name, boolean typed) {
        if (bw.proxy() instanceof AspectUtil) {
            return false;
        }
        bw.proxySet((BeanWrap.Proxy)BeanProxy.getGlobal());
        bw.context().beanRegister(bw, name, typed);
        return true;
    }

    public static boolean binding(BeanWrap bw) {
        return AspectUtil.binding(bw, "", false);
    }

    public static void attach(Class<?> clz, InvocationHandler handler) {
        if (clz.isAnnotation() || clz.isInterface() || clz.isEnum() || clz.isPrimitive()) {
            return;
        }
        if (tryAttachCached.contains(clz)) {
            return;
        }
        tryAttachCached.add(clz);
        Solon.context().wrapAndPut(clz).proxySet((BeanWrap.Proxy)new BeanProxy(handler));
    }

    public static void attachByScan(String basePackage, InvocationHandler handler) {
        AspectUtil.attachByScan((ClassLoader)JarClassLoader.global(), basePackage, null, handler);
    }

    public static void attachByScan(String basePackage, Predicate<String> filter, InvocationHandler handler) {
        AspectUtil.attachByScan((ClassLoader)JarClassLoader.global(), basePackage, filter, handler);
    }

    public static void attachByScan(ClassLoader classLoader, String basePackage, Predicate<String> filter, InvocationHandler handler) {
        if (Utils.isEmpty((String)basePackage)) {
            return;
        }
        if (classLoader == null) {
            return;
        }
        if (filter == null) {
            filter = s -> true;
        }
        String dir = basePackage.replace('.', '/');
        ScanUtil.scan((ClassLoader)classLoader, (String)dir, n -> n.endsWith(".class")).stream().sorted(Comparator.comparing(s -> s.length())).filter(filter).forEach(name -> {
            String className = name.substring(0, name.length() - 6);
            Class clz = Utils.loadClass((ClassLoader)classLoader, (String)className.replace("/", "."));
            if (clz != null) {
                AspectUtil.attach(clz, handler);
            }
        });
    }
}

