/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.aspect.asm;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.aspect.asm.MethodBean;
import org.noear.solon.core.event.EventBus;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class TargetClassVisitor
extends ClassVisitor {
    private boolean isFinal;
    private List<MethodBean> methods = new ArrayList<MethodBean>();
    private List<MethodBean> declaredMethods = new ArrayList<MethodBean>();
    private List<MethodBean> constructors = new ArrayList<MethodBean>();

    public TargetClassVisitor() {
        super(524288);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        List<MethodBean> beans;
        super.visit(version, access, name, signature, superName, interfaces);
        if ((access & 0x10) == 16) {
            this.isFinal = true;
        }
        if (superName != null && (beans = this.initMethodBeanByParent(superName)) != null && !beans.isEmpty()) {
            for (MethodBean bean : beans) {
                if (this.methods.contains(bean)) continue;
                this.methods.add(bean);
            }
        }
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if ("<init>".equals(name)) {
            MethodBean constructor = new MethodBean(access, name, descriptor);
            this.constructors.add(constructor);
        } else if (!"<clinit>".equals(name)) {
            if ((access & 0x10) == 16 || (access & 8) == 8) {
                return super.visitMethod(access, name, descriptor, signature, exceptions);
            }
            MethodBean methodBean = new MethodBean(access, name, descriptor);
            this.declaredMethods.add(methodBean);
            if ((access & 1) == 1) {
                this.methods.add(methodBean);
            }
        }
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public List<MethodBean> getMethods() {
        return this.methods;
    }

    public List<MethodBean> getDeclaredMethods() {
        return this.declaredMethods;
    }

    public List<MethodBean> getConstructors() {
        return this.constructors;
    }

    private List<MethodBean> initMethodBeanByParent(String superName) {
        try {
            if (superName != null && !superName.isEmpty()) {
                ClassReader reader = new ClassReader(superName);
                TargetClassVisitor visitor = new TargetClassVisitor();
                reader.accept((ClassVisitor)visitor, 2);
                ArrayList<MethodBean> beans = new ArrayList<MethodBean>();
                for (MethodBean methodBean : visitor.methods) {
                    if ((methodBean.access & 0x10) == 16 || (methodBean.access & 8) == 8 || (methodBean.access & 1) != 1) continue;
                    beans.add(methodBean);
                }
                return beans;
            }
        }
        catch (Exception ex) {
            EventBus.push((Object)ex);
        }
        return null;
    }
}

