/*
 * Decompiled with CFR 0.152.
 */
package org.noear.fineio.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import org.noear.fineio.NetServer;
import org.noear.fineio.nio.NioTcpSession;

public class NioTcpServer<T>
extends NetServer<T> {
    private ByteBuffer buffer = ByteBuffer.allocate(1024);
    private Selector selector;

    @Override
    public void start(int port) throws IOException {
        ServerSocketChannel ssc = ServerSocketChannel.open();
        ssc.configureBlocking(false);
        ssc.socket().bind(new InetSocketAddress(port));
        this.selector = Selector.open();
        ssc.register(this.selector, 16);
        this.startDo();
    }

    private void startDo() {
        new Thread(() -> {
            while (!this._stop) {
                try {
                    if (this.selector.select(1000L) < 1) continue;
                    Iterator<SelectionKey> keyS = this.selector.selectedKeys().iterator();
                    while (keyS.hasNext()) {
                        SelectionKey key = keyS.next();
                        keyS.remove();
                        if (!key.isValid()) continue;
                        this.selectDo(key);
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        }).start();
    }

    private void selectDo(SelectionKey key) throws IOException {
        if (key.isAcceptable()) {
            ServerSocketChannel server = (ServerSocketChannel)key.channel();
            SocketChannel channel = server.accept();
            if (channel == null) {
                return;
            }
            channel.configureBlocking(false);
            channel.register(this.selector, 1);
            return;
        }
        if (key.isReadable()) {
            SocketChannel channel = (SocketChannel)key.channel();
            this.buffer.clear();
            channel.read(this.buffer);
            this.buffer.flip();
            Object message = this.protocol.decode(this.buffer);
            if (message != null) {
                NioTcpSession session = new NioTcpSession(channel, message);
                this.processor.process(session);
            }
        }
    }
}

