/*
 * Decompiled with CFR 0.152.
 */
package org.noear.fineio.extension;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.noear.fineio.NetSession;
import org.noear.fineio.SessionProcessor;

public class MessageProcessorPool<T>
implements SessionProcessor<T> {
    private SessionProcessor<T> processor;
    private ExecutorService processorPool;

    public MessageProcessorPool(SessionProcessor<T> processor) {
        this.processor = processor;
        this.processorPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
    }

    @Override
    public void process(NetSession<T> session) {
        this.processorPool.execute(() -> this.processor.process(session));
    }
}

