/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jdksocket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.noear.solon.boot.jdksocket.SocketProtocol;
import org.noear.solonclient.channel.SocketMessage;

public class SocketSession {
    private final Socket connector;

    public SocketSession(Socket connector) {
        this.connector = connector;
    }

    public boolean isOpen() {
        return !this.connector.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Socket socket = this.connector;
        synchronized (socket) {
            this.connector.shutdownInput();
            this.connector.shutdownOutput();
            this.connector.close();
        }
    }

    public InetAddress getRemoteAddress() {
        return this.connector.getInetAddress();
    }

    public SocketMessage receive(SocketProtocol protocol) {
        try {
            return protocol.decode(this.connector, this.connector.getInputStream());
        }
        catch (SocketException ex) {
            return null;
        }
        catch (Throwable ex) {
            System.out.println("Decoding failure::");
            ex.printStackTrace();
            return null;
        }
    }

    public void publish(SocketMessage message) throws IOException {
        this.connector.getOutputStream().write(message.encode().array());
        this.connector.getOutputStream().flush();
    }
}

