/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jdksocket;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.noear.solon.boot.jdksocket.SocketContextHandler;
import org.noear.solon.boot.jdksocket.SocketProtocol;
import org.noear.solon.boot.jdksocket.SocketSession;
import org.noear.solon.core.SocketMessage;

public class SocketServer {
    private ServerSocket server;
    private SocketProtocol protocol;
    private ExecutorService pool = Executors.newCachedThreadPool();
    private SocketContextHandler handler;

    public void setHandler(SocketContextHandler handler) {
        this.handler = handler;
    }

    public void setProtocol(SocketProtocol protocol) {
        this.protocol = protocol;
    }

    public void start(int port) {
        new Thread(() -> {
            try {
                this.do_start(port);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }).start();
    }

    private void do_start(int port) throws IOException {
        this.server = new ServerSocket(port);
        System.out.println("Server started, waiting for customer connection...");
        while (true) {
            Socket connector = this.server.accept();
            SocketSession session = new SocketSession(connector);
            this.pool.execute(() -> {
                while (session.isOpen()) {
                    SocketMessage msg = session.receive(this.protocol);
                    if (msg == null) continue;
                    this.pool.execute(() -> this.handler.handler(session, msg));
                }
                return;
            });
        }
    }

    public void stop() {
        if (this.server.isClosed()) {
            return;
        }
        try {
            this.server.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

