/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jdksocket;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.noear.solonclient.channel.SocketMessage;

public class SocketProtocol {
    public SocketMessage decode(Socket connector, InputStream input) throws IOException {
        if (input == null) {
            return null;
        }
        byte[] lenBts = new byte[4];
        if (input.read(lenBts) < -1) {
            return null;
        }
        int len = SocketProtocol.bytesToInt32(lenBts);
        if (len < 6) {
            return null;
        }
        byte[] bytes = new byte[len];
        bytes[0] = lenBts[0];
        bytes[1] = lenBts[1];
        bytes[2] = lenBts[2];
        bytes[3] = lenBts[3];
        input.read(bytes, 4, len - 4);
        return SocketMessage.decode((ByteBuffer)ByteBuffer.wrap(bytes));
    }

    private static int bytesToInt32(byte[] bs) {
        int num1 = 0;
        num1 ^= bs[0];
        num1 <<= 24;
        int num2 = 0;
        num2 ^= bs[1];
        int num3 = 0;
        num3 ^= bs[2];
        int num4 = 0;
        return num1 ^ (num2 <<= 16) ^ (num3 <<= 8) ^ (num4 ^= bs[3]);
    }
}

