/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jdksocket;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.noear.solon.boot.jdksocket._SocketSession;
import org.noear.solon.core.XMessage;
import org.noear.solon.core.XSession;
import org.noear.solon.extend.xsocket.XListenerProxy;

public class SocketServer {
    private ServerSocket server;
    private ExecutorService pool = Executors.newCachedThreadPool();

    public void start(int port) {
        new Thread(() -> {
            try {
                this.start0(port);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }).start();
    }

    private void start0(int port) throws IOException {
        this.server = new ServerSocket(port);
        System.out.println("Server started, waiting for customer connection...");
        while (true) {
            Socket socket = this.server.accept();
            XSession session = _SocketSession.get(socket);
            XListenerProxy.getGlobal().onOpen(session);
            this.pool.execute(() -> {
                while (true) {
                    if (socket.isClosed()) break;
                    XMessage message = _SocketSession.receive(socket);
                    if (message == null) continue;
                    this.pool.execute(() -> {
                        try {
                            XListenerProxy.getGlobal().onMessage(session, message, false);
                        }
                        catch (Throwable ex) {
                            XListenerProxy.getGlobal().onError(session, ex);
                        }
                    });
                }
                XListenerProxy.getGlobal().onClose(session);
            });
        }
    }

    public void stop() {
        if (this.server.isClosed()) {
            return;
        }
        try {
            this.server.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

