/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jdksocket;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.noear.solon.Utils;
import org.noear.solon.boot.jdksocket.SocketProtocol;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.extend.xsocket.MessageUtils;
import org.noear.solon.extend.xsocket.SessionBase;

class _SocketSession
extends SessionBase {
    public static Map<Socket, Session> sessions = new HashMap<Socket, Session>();
    Socket real;
    private String _sessionId = Utils.guid();
    private Object attachment;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session get(Socket real) {
        Object tmp = sessions.get(real);
        if (tmp == null) {
            Socket socket = real;
            synchronized (socket) {
                tmp = sessions.get(real);
                if (tmp == null) {
                    tmp = new _SocketSession(real);
                    sessions.put(real, (Session)tmp);
                }
            }
        }
        return tmp;
    }

    public static void remove(Socket real) {
        sessions.remove(real);
    }

    public _SocketSession(Socket real) {
        this.real = real;
    }

    public Object real() {
        return this.real;
    }

    public String sessionId() {
        return this._sessionId;
    }

    public MethodType method() {
        return MethodType.SOCKET;
    }

    public String path() {
        return "";
    }

    public void send(String message) {
        try {
            this.send(message.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void send(byte[] message) {
        this.send(Message.wrap((byte[])message));
    }

    public void send(Message message) {
        try {
            byte[] bytes = MessageUtils.encode((Message)message).array();
            this.real.getOutputStream().write(bytes);
            this.real.getOutputStream().flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Message sendAndResponse(Message message) {
        this.send(message);
        return _SocketSession.receive(this.real);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Socket socket = this.real;
        synchronized (socket) {
            this.real.shutdownInput();
            this.real.shutdownOutput();
            this.real.close();
            sessions.remove(this.real);
        }
    }

    public boolean isValid() {
        return this.real.isConnected();
    }

    public boolean isSecure() {
        return false;
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.real.getRemoteSocketAddress();
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.real.getLocalSocketAddress();
    }

    public void setAttachment(Object obj) {
        this.attachment = obj;
    }

    public <T> T getAttachment() {
        return (T)this.attachment;
    }

    public Collection<Session> getOpenSessions() {
        return new ArrayList<Session>(sessions.values());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        _SocketSession that = (_SocketSession)((Object)o);
        return Objects.equals(this.real, that.real);
    }

    public int hashCode() {
        return Objects.hash(this.real);
    }

    public static Message receive(Socket socket) {
        try {
            return SocketProtocol.instance.decode(socket.getInputStream());
        }
        catch (SocketException ex) {
            return null;
        }
        catch (Throwable ex) {
            System.out.println("Decoding failure::");
            ex.printStackTrace();
            return null;
        }
    }
}

