/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jlhttp;

import javax.net.ssl.SSLServerSocketFactory;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.boot.jlhttp.HTTPServer;
import org.noear.solon.boot.jlhttp.JlHttpContextHandler;
import org.noear.solon.boot.jlhttp.XServerProp;
import org.noear.solon.core.Aop;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.util.PrintUtil;

public final class XPluginImp
implements Plugin {
    private HTTPServer _server = null;

    public static String solon_boot_ver() {
        return "jlhttp 2.4/" + Solon.cfg().version();
    }

    public void start(SolonApp app) {
        if (!app.enableHttp()) {
            return;
        }
        if (Utils.loadClass((String)"org.noear.solon.boot.jetty.XPluginImp") != null) {
            return;
        }
        if (Utils.loadClass((String)"org.noear.solon.boot.undertow.XPluginImp") != null) {
            return;
        }
        XServerProp.init();
        Aop.beanOnloaded(() -> this.start0(app));
    }

    private void start0(SolonApp app) {
        this._server = new HTTPServer();
        String _name = app.cfg().get("server.http.name");
        int _port = app.cfg().getInt("server.http.port", 0);
        if (_port < 1) {
            _port = app.port();
        }
        long time_start = System.currentTimeMillis();
        JlHttpContextHandler _handler = new JlHttpContextHandler();
        if (System.getProperty("javax.net.ssl.keyStore") != null) {
            this._server.setServerSocketFactory(SSLServerSocketFactory.getDefault());
        }
        HTTPServer.VirtualHost host = this._server.getVirtualHost(null);
        host.setDirectoryIndex(null);
        host.addContext("/", _handler, MethodType.HEAD.name, MethodType.GET.name, MethodType.POST.name, MethodType.PUT.name, MethodType.DELETE.name, MethodType.PATCH.name);
        PrintUtil.info((Object)"solon.server:main: JlHttpServer 2.4(jlhttp)");
        try {
            this._server.setPort(_port);
            this._server.start();
            app.signalAdd((Signal)new SignalSim(_name, _port, "http", SignalType.HTTP));
            long time_end = System.currentTimeMillis();
            PrintUtil.info((Object)("solon.connector:main: jlhttp: Started ServerConnector@{HTTP/1.1,[http/1.1]}{0.0.0.0:" + _port + "}"));
            PrintUtil.info((Object)("solon.server:main: jlhttp: Started @" + (time_end - time_start) + "ms"));
        }
        catch (Exception ex) {
            EventBus.push((Object)ex);
        }
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
            PrintUtil.info((Object)("solon.server:main: jlhttp: Has Stopped " + XPluginImp.solon_boot_ver()));
        }
    }
}

