/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smartsocket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.noear.solon.XUtil;
import org.noear.solon.boot.smartsocket.SsRequest;
import org.noear.solon.boot.smartsocket.SsResponse;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XFile;
import org.noear.solon.core.XMap;

public class SsContext
extends XContext {
    private SsRequest _request;
    private SsResponse _response;
    private URI _uri;
    private XMap _paramMap;

    public SsContext(SsRequest request, SsResponse response) {
        this._request = request;
        this._response = response;
    }

    public Object request() {
        return this._request;
    }

    public String ip() {
        if (this._request.getRemoteAddr() == null) {
            return null;
        }
        return this._request.getRemoteAddr().getAddress().toString();
    }

    public boolean isMultipart() {
        return false;
    }

    public String method() {
        return this._request.getMethod();
    }

    public String protocol() {
        return this._request.getProtocol();
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this._request.getRequestUrl());
        }
        return this._uri;
    }

    public String path() {
        return this.uri().getPath();
    }

    public String url() {
        return this._request.getRequestUrl();
    }

    public long contentLength() {
        try {
            if (this._request.getBody() != null) {
                return this._request.getBody().available();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return 0L;
    }

    public String contentType() {
        return this.header("Content-Type");
    }

    public String body() throws IOException {
        InputStream inpStream = this.bodyAsStream();
        StringBuilder content = new StringBuilder();
        byte[] b = new byte[1024];
        int lens = -1;
        while ((lens = inpStream.read(b)) > 0) {
            content.append(new String(b, 0, lens));
        }
        return content.toString();
    }

    public InputStream bodyAsStream() throws IOException {
        return this._request.getBody();
    }

    public String[] paramValues(String key) {
        return this.paramMap().values().toArray(new String[0]);
    }

    public String param(String key) {
        return (String)this.paramMap().get((Object)key);
    }

    public String param(String key, String def) {
        try {
            String temp = (String)this.paramMap().get((Object)key);
            if (XUtil.isEmpty((String)temp)) {
                return def;
            }
            return temp;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return def;
        }
    }

    public int paramAsInt(String key) {
        return Integer.parseInt(this.param(key, "0"));
    }

    public long paramAsLong(String key) {
        return Long.parseLong(this.param(key, "0"));
    }

    public double paramAsDouble(String key) {
        return Double.parseDouble(this.param(key, "0"));
    }

    public XMap paramMap() {
        if (this._paramMap == null) {
            this._paramMap = new XMap();
            try {
                this._paramMap.putAll(this._request.getParams());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this._paramMap;
    }

    public void paramSet(String key, String val) {
        this.paramMap().put((Object)key, (Object)val);
    }

    public List<XFile> files(String key) {
        return new ArrayList<XFile>();
    }

    public String cookie(String key) {
        return null;
    }

    public String cookie(String key, String def) {
        return null;
    }

    public XMap cookieMap() {
        return null;
    }

    public String header(String key) {
        return this._request.header(key);
    }

    public String header(String key, String def) {
        String temp = this._request.header(key);
        if (temp == null) {
            return def;
        }
        return temp;
    }

    public XMap headerMap() {
        return new XMap(this._request.getHeaders());
    }

    public String sessionId() {
        return null;
    }

    public Object session(String key) {
        return null;
    }

    public void sessionSet(String key, Object val) {
    }

    public Object response() {
        return this._response;
    }

    public void charset(String charset) {
        this._response.setCharacterEncoding(charset);
    }

    public void contentType(String contentType) {
        this.headerSet("Content-Type", contentType);
    }

    public OutputStream outputStream() {
        return this._response.getOutputStream();
    }

    public void output(String str) throws IOException {
        this._response.getOutputStream().write(str.getBytes(this._response.getCharacterEncoding()));
    }

    public void output(InputStream stream) throws IOException {
        OutputStream out = this._response.getOutputStream();
        byte[] buff = new byte[100];
        int rc = 0;
        while ((rc = stream.read(buff, 0, 100)) > 0) {
            out.write(buff, 0, rc);
        }
        out.flush();
    }

    public void headerSet(String key, String val) {
        this._response.headerSet(key, val);
    }

    public void cookieSet(String key, String val, int maxAge) {
    }

    public void cookieSet(String key, String val, String domain, int maxAge) {
    }

    public void cookieSet(String key, String val, String domain, String path, int maxAge) {
    }

    public void cookieRemove(String key) {
    }

    public void redirect(String url) throws IOException {
        this.redirect(url, 301);
    }

    public void redirect(String url, int code) throws IOException {
        this.headerSet("Location", url);
        this._response.setStatus(code);
    }

    public int status() {
        return this._response.getStatus();
    }

    public void status(int status) throws IOException {
        this._response.setStatus(status);
    }
}

