/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smartsocket;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.noear.solon.boot.smartsocket.SsContextHandler;
import org.noear.solon.boot.smartsocket.SsRequest;
import org.noear.solon.boot.smartsocket.SsResponse;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.transport.AioSession;

public class SsProcessor
implements MessageProcessor<byte[]> {
    private SsContextHandler _contextHandler;

    public SsProcessor(SsContextHandler contextHandler) {
        this._contextHandler = contextHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(AioSession<byte[]> session, byte[] msg) {
        ObjectInput objectInput = null;
        ObjectOutput objectOutput = null;
        try {
            objectInput = new ObjectInputStream(new ByteArrayInputStream(msg));
            Map rpcxMsg = (Map)objectInput.readObject();
            SsRequest request = new SsRequest(rpcxMsg);
            SsResponse response = new SsResponse(request);
            request.setRemoteAddr(session.getRemoteAddress());
            this._contextHandler.handle(request, response);
            response.close();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutput = new ObjectOutputStream(byteArrayOutputStream);
            objectOutput.writeObject(response.message());
            session.write(byteArrayOutputStream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (objectInput != null) {
                try {
                    objectInput.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (objectOutput != null) {
                try {
                    objectOutput.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void stateEvent(AioSession<byte[]> session, StateMachineEnum stateMachineEnum, Throwable throwable) {
    }
}

