/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smartsocket;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.boot.smartsocket.SsRequest;

public class SsResponse
implements Serializable {
    private Map<String, Object> _message = new HashMap<String, Object>();
    private String requestId;
    private int status;
    private final Map<String, String> headers = new HashMap<String, String>();
    private byte[] outputBody;
    private transient PrintWriter writer;
    private transient OutputStream outputStream;
    private String characterEncoding = "UTF-8";
    private Exception exception;

    public SsResponse(SsRequest request) {
        this.requestId = request.getRequestId();
        this.outputStream = new ByteArrayOutputStream();
        this.writer = new PrintWriter(this.outputStream);
    }

    public Map<String, Object> message() {
        this._message.put("request_id", this.requestId);
        this._message.put("status", this.status);
        this._message.put("characterEncoding", this.characterEncoding);
        this._message.put("exception", this.exception);
        if (this.headers.size() > 0) {
            this._message.put("headers", this.headers);
        }
        if (this.outputBody != null) {
            this._message.put("body", this.outputBody);
        }
        return this._message;
    }

    public String body() throws IOException {
        return new String(this.outputBody, this.getCharacterEncoding());
    }

    public InputStream bodyAsStream() {
        return new ByteArrayInputStream(this.outputBody);
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void headerSet(String key, String val) {
        this.headers.put(key, val);
    }

    public String header(String key) {
        return this.headers.get(key);
    }

    public void close() {
        this.outputBody = ((ByteArrayOutputStream)this.outputStream).toByteArray();
    }
}

