/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadFactory;
import org.smartboot.socket.Filter;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.transport.AioSession;
import org.smartboot.socket.transport.IoServerConfig;
import org.smartboot.socket.transport.ReadCompletionHandler;
import org.smartboot.socket.transport.WriteCompletionHandler;

public class AioQuickClient<T> {
    protected IoServerConfig<T> config = new IoServerConfig();
    protected AioSession<T> session;
    private AsynchronousChannelGroup asynchronousChannelGroup;

    public AioQuickClient(String host, int port, Protocol<T> protocol, MessageProcessor<T> messageProcessor) {
        this.config.setHost(host);
        this.config.setPort(port);
        this.config.setProtocol(protocol);
        this.config.setProcessor(messageProcessor);
    }

    public void start(AsynchronousChannelGroup asynchronousChannelGroup) throws IOException, ExecutionException, InterruptedException {
        AsynchronousSocketChannel socketChannel = AsynchronousSocketChannel.open(asynchronousChannelGroup);
        if (this.config.getSocketOptions() != null) {
            for (Map.Entry<SocketOption<Object>, Object> entry : this.config.getSocketOptions().entrySet()) {
                socketChannel.setOption((SocketOption)entry.getKey(), entry.getValue());
            }
        }
        socketChannel.connect(new InetSocketAddress(this.config.getHost(), this.config.getPort())).get();
        this.session = new AioSession<T>(socketChannel, this.config, new ReadCompletionHandler(), new WriteCompletionHandler(), false);
        this.session.initSession();
    }

    public final void start() throws IOException, ExecutionException, InterruptedException {
        this.asynchronousChannelGroup = AsynchronousChannelGroup.withFixedThreadPool(2, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r);
            }
        });
        this.start(this.asynchronousChannelGroup);
    }

    public final void shutdown() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        if (this.asynchronousChannelGroup != null) {
            this.asynchronousChannelGroup.shutdown();
        }
    }

    public final AioQuickClient<T> setFilters(Filter<T>[] filters) {
        this.config.setFilters(filters);
        return this;
    }

    public final AioQuickClient<T> setReadBufferSize(int size) {
        this.config.setReadBufferSize(size);
        return this;
    }

    public final AioQuickClient<T> setWriteQueueSize(int size) {
        this.config.setWriteQueueSize(size);
        return this;
    }

    public final AioQuickClient<T> setDirectBuffer(boolean directBuffer) {
        this.config.setDirectBuffer(directBuffer);
        return this;
    }

    public final <V> AioQuickClient<T> setOption(SocketOption<V> socketOption, V value) {
        this.config.setOption(socketOption, value);
        return this;
    }
}

