/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.Filter;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.transport.AioSession;
import org.smartboot.socket.transport.IoServerConfig;
import org.smartboot.socket.transport.ReadCompletionHandler;
import org.smartboot.socket.transport.WriteCompletionHandler;

public class AioQuickServer<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AioQuickServer.class);
    protected IoServerConfig<T> config = new IoServerConfig();
    protected ReadCompletionHandler<T> aioReadCompletionHandler = new ReadCompletionHandler();
    protected WriteCompletionHandler<T> aioWriteCompletionHandler = new WriteCompletionHandler();
    private AsynchronousServerSocketChannel serverSocketChannel = null;
    private AsynchronousChannelGroup asynchronousChannelGroup;

    public AioQuickServer(int port, Protocol<T> protocol, MessageProcessor<T> messageProcessor) {
        this.config.setPort(port);
        this.config.setProtocol(protocol);
        this.config.setProcessor(messageProcessor);
    }

    public AioQuickServer(String host, int port, Protocol<T> protocol, MessageProcessor<T> messageProcessor) {
        this(port, protocol, messageProcessor);
        this.config.setHost(host);
    }

    public void start() throws IOException {
        if (this.config.isBannerEnabled()) {
            LOGGER.info("                               _                           _             _   \n                              ( )_                        ( )           ( )_ \n  ___   ___ ___     _ _  _ __ | ,_)     ___    _      ___ | |/')    __  | ,_)\n/',__)/' _ ` _ `\\ /'_` )( '__)| |     /',__) /'_`\\  /'___)| , <   /'__`\\| |  \n\\__, \\| ( ) ( ) |( (_| || |   | |_    \\__, \\( (_) )( (___ | |\\`\\ (  ___/| |_ \n(____/(_) (_) (_)`\\__,_)(_)   `\\__)   (____/`\\___/'`\\____)(_) (_)`\\____)`\\__)\r\n :: smart-socket ::\t(v1.3.12)");
        }
        this.start0();
    }

    protected final void start0() throws IOException {
        try {
            this.asynchronousChannelGroup = AsynchronousChannelGroup.withFixedThreadPool(this.config.getThreadNum(), new ThreadFactory(){
                byte index = 0;

                @Override
                public Thread newThread(Runnable r) {
                    this.index = (byte)(this.index + 1);
                    return new Thread(r, "smart-socket:AIO-" + this.index);
                }
            });
            this.serverSocketChannel = AsynchronousServerSocketChannel.open(this.asynchronousChannelGroup);
            if (this.config.getSocketOptions() != null) {
                for (Map.Entry<SocketOption<Object>, Object> entry : this.config.getSocketOptions().entrySet()) {
                    this.serverSocketChannel.setOption((SocketOption)entry.getKey(), entry.getValue());
                }
            }
            if (this.config.getHost() != null) {
                this.serverSocketChannel.bind(new InetSocketAddress(this.config.getHost(), this.config.getPort()), 1000);
            } else {
                this.serverSocketChannel.bind(new InetSocketAddress(this.config.getPort()), 1000);
            }
            this.serverSocketChannel.accept(this.serverSocketChannel, new CompletionHandler<AsynchronousSocketChannel, AsynchronousServerSocketChannel>(){

                @Override
                public void completed(AsynchronousSocketChannel channel, AsynchronousServerSocketChannel serverSocketChannel) {
                    serverSocketChannel.accept(serverSocketChannel, this);
                    AioQuickServer.this.createSession(channel);
                }

                @Override
                public void failed(Throwable exc, AsynchronousServerSocketChannel serverSocketChannel) {
                    LOGGER.error("smart-socket server accept fail", exc);
                }
            });
        }
        catch (IOException e) {
            this.shutdown();
            throw e;
        }
        LOGGER.info("smart-socket server started on port {}", (Object)this.config.getPort());
        LOGGER.info("smart-socket server config is {}", (Object)this.config);
    }

    protected void createSession(AsynchronousSocketChannel channel) {
        AioSession<T> session = new AioSession<T>(channel, this.config, this.aioReadCompletionHandler, this.aioWriteCompletionHandler, true);
        session.initSession();
    }

    public final void shutdown() {
        try {
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
                this.serverSocketChannel = null;
            }
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage(), e);
        }
        if (!this.asynchronousChannelGroup.isTerminated()) {
            try {
                this.asynchronousChannelGroup.shutdownNow();
            }
            catch (IOException e) {
                LOGGER.error("shutdown exception", e);
            }
        }
        try {
            this.asynchronousChannelGroup.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.error("shutdown exception", e);
        }
    }

    public final AioQuickServer<T> setThreadNum(int num) {
        this.config.setThreadNum(num);
        return this;
    }

    @SafeVarargs
    public final AioQuickServer<T> setFilters(Filter<T> ... filters) {
        this.config.setFilters(filters);
        return this;
    }

    public final AioQuickServer<T> setWriteQueueSize(int size) {
        this.config.setWriteQueueSize(size);
        return this;
    }

    public final AioQuickServer<T> setReadBufferSize(int size) {
        this.config.setReadBufferSize(size);
        return this;
    }

    public final AioQuickServer<T> setBannerEnabled(boolean bannerEnabled) {
        this.config.setBannerEnabled(bannerEnabled);
        return this;
    }

    public final AioQuickServer<T> setDirectBuffer(boolean directBuffer) {
        this.config.setDirectBuffer(directBuffer);
        return this;
    }

    public final <V> AioQuickServer<T> setOption(SocketOption<V> socketOption, V value) {
        this.config.setOption(socketOption, value);
        return this;
    }

    public final AioQuickServer<T> setFlowControlEnabled(boolean flowControlEnabled) {
        this.config.setFlowControlEnabled(flowControlEnabled);
        return this;
    }
}

