/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.Filter;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.transport.FastBlockingQueue;
import org.smartboot.socket.transport.IoServerConfig;
import org.smartboot.socket.transport.ReadCompletionHandler;
import org.smartboot.socket.transport.WriteCompletionHandler;

public class AioSession<T> {
    protected static final byte SESSION_STATUS_CLOSED = 1;
    protected static final byte SESSION_STATUS_CLOSING = 2;
    protected static final byte SESSION_STATUS_ENABLED = 3;
    private static final Logger logger = LoggerFactory.getLogger(AioSession.class);
    private static final int MAX_WRITE_SIZE = 262144;
    protected Boolean serverFlowLimit;
    protected AsynchronousSocketChannel channel;
    protected ByteBuffer readBuffer;
    protected ByteBuffer writeBuffer;
    protected byte status = (byte)3;
    private Object attachment;
    private FastBlockingQueue writeCacheQueue;
    private ReadCompletionHandler<T> readCompletionHandler;
    private WriteCompletionHandler<T> writeCompletionHandler;
    private Semaphore semaphore = new Semaphore(1);
    private IoServerConfig<T> ioServerConfig;
    private InputStream inputStream;

    AioSession(AsynchronousSocketChannel channel, IoServerConfig<T> config, ReadCompletionHandler<T> readCompletionHandler, WriteCompletionHandler<T> writeCompletionHandler, boolean serverSession) {
        this.channel = channel;
        this.readCompletionHandler = readCompletionHandler;
        this.writeCompletionHandler = writeCompletionHandler;
        if (config.getWriteQueueSize() > 0) {
            this.writeCacheQueue = new FastBlockingQueue(config.getWriteQueueSize());
        }
        this.ioServerConfig = config;
        this.serverFlowLimit = serverSession && config.getWriteQueueSize() > 0 && config.isFlowControlEnabled() ? Boolean.valueOf(false) : null;
        config.getProcessor().stateEvent(this, StateMachineEnum.NEW_SESSION, null);
        this.readBuffer = this.allocateReadBuffer(config.getReadBufferSize());
        for (Filter<T> filter : config.getFilters()) {
            filter.connected(this);
        }
    }

    void initSession() {
        this.continueRead();
    }

    void writeToChannel() {
        if (this.writeBuffer != null && this.writeBuffer.hasRemaining()) {
            this.continueWrite();
            return;
        }
        if (this.writeCacheQueue == null || this.writeCacheQueue.size() == 0) {
            this.writeBuffer = null;
            this.semaphore.release();
            if (this.isInvalid()) {
                this.close();
            } else if (this.writeCacheQueue != null && this.writeCacheQueue.size() > 0 && this.semaphore.tryAcquire()) {
                this.writeToChannel();
            }
            return;
        }
        int totalSize = this.writeCacheQueue.expectRemaining(262144);
        ByteBuffer headBuffer = this.writeCacheQueue.poll();
        if (headBuffer.remaining() == totalSize) {
            this.writeBuffer = headBuffer;
        } else {
            if (this.writeBuffer == null || totalSize << 1 <= this.writeBuffer.capacity() || totalSize > this.writeBuffer.capacity()) {
                this.writeBuffer = this.allocateReadBuffer(totalSize);
            } else {
                this.writeBuffer.clear().limit(totalSize);
            }
            this.writeBuffer.put(headBuffer);
            this.writeCacheQueue.pollInto(this.writeBuffer);
            this.writeBuffer.flip();
        }
        if (this.serverFlowLimit != null && this.serverFlowLimit.booleanValue() && this.writeCacheQueue.size() < this.ioServerConfig.getReleaseLine()) {
            this.ioServerConfig.getProcessor().stateEvent(this, StateMachineEnum.RELEASE_FLOW_LIMIT, null);
            this.serverFlowLimit = false;
            this.continueRead();
        }
        this.continueWrite();
    }

    protected final void readFromChannel0(ByteBuffer buffer) {
        this.channel.read(buffer, this, this.readCompletionHandler);
    }

    protected final void writeToChannel0(ByteBuffer buffer) {
        this.channel.write(buffer, this, this.writeCompletionHandler);
    }

    public final void write(ByteBuffer buffer) throws IOException {
        if (this.isInvalid()) {
            throw new IOException("session is " + (this.status == 1 ? "closed" : "invalid"));
        }
        if (!buffer.hasRemaining()) {
            throw new InvalidObjectException("buffer has no remaining");
        }
        if (this.ioServerConfig.getWriteQueueSize() <= 0) {
            try {
                this.semaphore.acquire();
                this.writeBuffer = buffer;
                this.continueWrite();
            }
            catch (InterruptedException e) {
                logger.error("acquire fail", e);
                Thread.currentThread().interrupt();
                throw new IOException(e.getMessage());
            }
            return;
        }
        if (this.semaphore.tryAcquire()) {
            this.writeBuffer = buffer;
            this.continueWrite();
            return;
        }
        try {
            this.writeCacheQueue.put(buffer);
        }
        catch (InterruptedException e) {
            logger.error("put buffer into cache fail", e);
            Thread.currentThread().interrupt();
        }
        if (this.semaphore.tryAcquire()) {
            this.writeToChannel();
        }
    }

    public final void close() {
        this.close(true);
    }

    public void close(boolean immediate) {
        if (this.status == 1) {
            logger.warn("ignore, session:{} is closed:", (Object)this.getSessionID());
            return;
        }
        this.status = (byte)(immediate ? 1 : 2);
        if (immediate) {
            try {
                this.channel.shutdownInput();
            }
            catch (IOException e) {
                logger.debug(e.getMessage(), e);
            }
            try {
                this.channel.shutdownOutput();
            }
            catch (IOException e) {
                logger.debug(e.getMessage(), e);
            }
            try {
                this.channel.close();
                if (logger.isDebugEnabled()) {
                    logger.debug("session:{} is closed:", (Object)this.getSessionID());
                }
                this.channel = null;
            }
            catch (IOException e) {
                logger.debug("close session exception", e);
            }
            for (Filter<T> filter : this.ioServerConfig.getFilters()) {
                filter.closed(this);
            }
            this.ioServerConfig.getProcessor().stateEvent(this, StateMachineEnum.SESSION_CLOSED, null);
        } else if (!(this.writeBuffer != null && this.writeBuffer.hasRemaining() || this.writeCacheQueue != null && this.writeCacheQueue.size() != 0 || !this.semaphore.tryAcquire())) {
            this.close(true);
            this.semaphore.release();
        } else {
            this.ioServerConfig.getProcessor().stateEvent(this, StateMachineEnum.SESSION_CLOSING, null);
        }
    }

    public final String getSessionID() {
        return "aioSession-" + this.hashCode();
    }

    public final boolean isInvalid() {
        return this.status != 3;
    }

    void readFromChannel(boolean eof) {
        T dataEntry;
        this.readBuffer.flip();
        while ((dataEntry = this.ioServerConfig.getProtocol().decode(this.readBuffer, this, eof)) != null) {
            try {
                for (Filter<T> h : this.ioServerConfig.getFilters()) {
                    h.processFilter(this, dataEntry);
                }
                this.ioServerConfig.getProcessor().process(this, dataEntry);
            }
            catch (Exception e) {
                this.ioServerConfig.getProcessor().stateEvent(this, StateMachineEnum.PROCESS_EXCEPTION, e);
                for (Filter<T> h : this.ioServerConfig.getFilters()) {
                    h.processFail(this, dataEntry, e);
                }
            }
        }
        if (eof || this.status == 2) {
            this.close(false);
            this.ioServerConfig.getProcessor().stateEvent(this, StateMachineEnum.INPUT_SHUTDOWN, null);
            return;
        }
        if (this.status == 1) {
            return;
        }
        if (this.readBuffer.remaining() == 0) {
            this.readBuffer.clear();
        } else if (this.readBuffer.position() > 0) {
            this.readBuffer.compact();
        } else {
            this.readBuffer.position(this.readBuffer.limit());
            this.readBuffer.limit(this.readBuffer.capacity());
        }
        if (this.serverFlowLimit != null && this.writeCacheQueue.size() > this.ioServerConfig.getFlowLimitLine()) {
            this.serverFlowLimit = true;
            this.ioServerConfig.getProcessor().stateEvent(this, StateMachineEnum.FLOW_LIMIT, null);
        } else {
            this.continueRead();
        }
    }

    protected void continueRead() {
        this.readFromChannel0(this.readBuffer);
    }

    protected void continueWrite() {
        this.writeToChannel0(this.writeBuffer);
    }

    public final <T> T getAttachment() {
        return (T)this.attachment;
    }

    public final <T> void setAttachment(T attachment) {
        this.attachment = attachment;
    }

    public final void write(T t) throws IOException {
        this.write(this.ioServerConfig.getProtocol().encode(t, this));
    }

    public final InetSocketAddress getLocalAddress() throws IOException {
        this.assertChannel();
        return (InetSocketAddress)this.channel.getLocalAddress();
    }

    public final InetSocketAddress getRemoteAddress() throws IOException {
        this.assertChannel();
        return (InetSocketAddress)this.channel.getRemoteAddress();
    }

    private void assertChannel() throws IOException {
        if (this.status == 1 || this.channel == null) {
            throw new IOException("session is closed");
        }
    }

    IoServerConfig<T> getServerConfig() {
        return this.ioServerConfig;
    }

    private ByteBuffer allocateReadBuffer(int size) {
        return this.ioServerConfig.isDirectBuffer() ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
    }

    public InputStream getInputStream() throws IOException {
        return this.inputStream == null ? this.getInputStream(-1) : this.inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(int length) throws IOException {
        if (this.inputStream != null) {
            throw new IOException("pre inputStream has not closed");
        }
        if (this.inputStream != null) {
            return this.inputStream;
        }
        AioSession aioSession = this;
        synchronized (aioSession) {
            if (this.inputStream == null) {
                this.inputStream = new InnerInputStream(length);
            }
        }
        return this.inputStream;
    }

    private class InnerInputStream
    extends InputStream {
        private int remainLength;

        public InnerInputStream(int length) {
            this.remainLength = length >= 0 ? length : -1;
        }

        @Override
        public int read() throws IOException {
            if (this.remainLength == 0) {
                return -1;
            }
            if (AioSession.this.readBuffer.hasRemaining()) {
                --this.remainLength;
                return AioSession.this.readBuffer.get();
            }
            AioSession.this.readBuffer.clear();
            try {
                int readSize = AioSession.this.channel.read(AioSession.this.readBuffer).get();
                AioSession.this.readBuffer.flip();
                if (readSize == -1) {
                    this.remainLength = 0;
                    return -1;
                }
                return this.read();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        @Override
        public int available() throws IOException {
            return this.remainLength == 0 ? 0 : AioSession.this.readBuffer.remaining();
        }

        @Override
        public void close() throws IOException {
            if (AioSession.this.inputStream == this) {
                AioSession.this.inputStream = null;
            }
        }
    }
}

